/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.viewInvoice;

import com.enniyal.enniyal_project.exception.ValidationException;
import com.enniyal.enniyal_project.viewInvoice.InvoiceDataDto;
import com.enniyal.enniyal_project.viewInvoice.InvoiceDto;
import org.springframework.stereotype.Service;

@Service
public class InvoiceValidation {
    public void validationRequest(InvoiceDto invoiceDto) {
        if (invoiceDto == null) {
            throw new ValidationException("InvoiceDto cannot be null");
        }
        if (invoiceDto.getInvoiceDate() == null) {
            throw new ValidationException("Invoice date is required");
        }
        if (invoiceDto.getClientId() == null) {
            throw new ValidationException("ClientId  is required");
        }
        if (invoiceDto.getCurrency() == null) {
            throw new ValidationException("Currency is required");
        }
        for (InvoiceDataDto dataDto : invoiceDto.getInvoiceDatas()) {
            if (dataDto.getItems() == null) {
                throw new ValidationException("Description is required");
            }
            if (dataDto.getActualAmount() == null) {
                throw new ValidationException("Actual amount is required");
            }
            if (dataDto.getInvoiceAmount() != null) continue;
            throw new ValidationException("Invoice amount is required");
        }
    }
}

