/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.viewInvoice;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.companyProfile.Profile;
import com.enniyal.enniyal_project.companyProfile.ProfileService;
import com.enniyal.enniyal_project.viewInvoice.Invoice;
import com.enniyal.enniyal_project.viewInvoice.InvoiceDao;
import com.enniyal.enniyal_project.viewInvoice.InvoiceData;
import com.enniyal.enniyal_project.viewInvoice.InvoiceDataDao;
import com.enniyal.enniyal_project.viewInvoice.InvoiceDataDto;
import com.enniyal.enniyal_project.viewInvoice.InvoiceDto;
import com.enniyal.enniyal_project.viewInvoice.InvoiceService;
import com.enniyal.enniyal_project.viewInvoice.InvoiceValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceServiceImpl
implements InvoiceService {
    @Autowired
    private InvoiceDao invoiceDao;
    @Autowired
    private InvoiceDataDao invoiceDataDao;
    private final ProfileService profileService;
    private final InvoiceValidation invoiceValidation;

    public ApplicationResponse<Invoice> createInvoice(InvoiceDto request) {
        try {
            this.invoiceValidation.validationRequest(request);
            Invoice invoice = this.mapRequestToEntity(request);
            Invoice model = this.invoiceDao.createInvoice(invoice);
            return ApplicationResponse.success((String)"Invoice is create successfully", (Object)model);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save Invoice" + e.getMessage()));
        }
    }

    private Invoice mapRequestToEntity(InvoiceDto request) {
        ArrayList<InvoiceData> savedInvoiceData = new ArrayList<InvoiceData>();
        ApplicationResponse profile = this.profileService.findAll();
        Double cgst = Double.parseDouble(((Profile)((List)profile.getData()).get(0)).getCgst());
        Double sgst = Double.parseDouble(((Profile)((List)profile.getData()).get(0)).getSgst());
        Double taxAmount = 0.0;
        Double grandTotal = 0.0;
        Double totalInvoiceAmount = 0.0;
        Invoice invoice = Invoice.builder().clientId(request.getClientId()).invoiceDate(request.getInvoiceDate()).currency(request.getCurrency()).build();
        Invoice savedInvoice = this.invoiceDao.createInvoice(invoice);
        if (request.getInvoiceDatas() != null) {
            for (InvoiceDataDto dataDto : request.getInvoiceDatas()) {
                InvoiceData data = new InvoiceData();
                totalInvoiceAmount = totalInvoiceAmount + dataDto.getInvoiceAmount();
                data.setItems(dataDto.getItems());
                data.setInvoiceAmount(dataDto.getInvoiceAmount());
                data.setActualAmount(dataDto.getActualAmount());
                data.setCGST(cgst);
                data.setSGST(sgst);
                data.setInvoice(savedInvoice);
                InvoiceData savedData = this.invoiceDataDao.createInvoice(data);
                savedInvoiceData.add(savedData);
            }
        }
        taxAmount = totalInvoiceAmount * ((cgst + sgst) / 100.0);
        grandTotal = totalInvoiceAmount + taxAmount;
        savedInvoice.setTaxAmount(taxAmount);
        savedInvoice.setGrandTotal(grandTotal);
        savedInvoice.setInvoiceDatas(savedInvoiceData);
        return savedInvoice;
    }

    public ApplicationResponse<List<Invoice>> findAll() {
        try {
            List list = this.invoiceDao.findAll();
            return ApplicationResponse.success((String)"find all Invoice", (Object)list);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all Invoice" + e.getMessage()));
        }
    }

    public ApplicationResponse<InvoiceDto> findById(Long id) {
        try {
            Optional optional = this.invoiceDao.findById(id);
            if (optional.isPresent()) {
                InvoiceDto invoiceDto = this.mapEntityToDto((Invoice)optional.get());
                return ApplicationResponse.success((String)"find by Invoice id is succefully", (Object)invoiceDto);
            }
            return ApplicationResponse.error((String)"Invoice id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Invoice id" + e.getMessage()));
        }
    }

    private InvoiceDto mapEntityToDto(Invoice invoice) {
        InvoiceDto dto = new InvoiceDto();
        ArrayList<InvoiceDataDto> savedInvoiceData = new ArrayList<InvoiceDataDto>();
        dto.setId(invoice.getId());
        dto.setClientId(invoice.getClientId());
        dto.setInvoiceDate(invoice.getInvoiceDate());
        dto.setInvoiceNumber(invoice.getInvoiceNumber());
        dto.setTaxAmount(invoice.getTaxAmount());
        dto.setGrandTotal(invoice.getGrandTotal());
        dto.setCreatedAt(invoice.getCreatedAt());
        for (InvoiceData data : invoice.getInvoiceDatas()) {
            InvoiceDataDto invoiceData = new InvoiceDataDto();
            invoiceData.setItems(data.getItems());
            invoiceData.setInvoiceAmount(data.getInvoiceAmount());
            invoiceData.setActualAmount(data.getActualAmount());
            invoiceData.setCGST(data.getCGST());
            invoiceData.setSGST(data.getSGST());
            savedInvoiceData.add(invoiceData);
        }
        dto.setInvoiceDatas(savedInvoiceData);
        return dto;
    }

    public ApplicationResponse<Invoice> updateById(Long id, InvoiceDto request) {
        try {
            this.deleteById(id);
            return this.createInvoice(request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update Invoice" + e.getMessage()));
        }
    }

    public ApplicationResponse<Invoice> deleteById(Long id) {
        try {
            this.invoiceDao.deleteById(id);
            return ApplicationResponse.success((String)"Invoice id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Invoice id" + e.getMessage()));
        }
    }

    @Generated
    public InvoiceServiceImpl(ProfileService profileService, InvoiceValidation invoiceValidation) {
        this.profileService = profileService;
        this.invoiceValidation = invoiceValidation;
    }
}

