/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.viewInvoice;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.viewInvoice.Invoice;
import com.enniyal.enniyal_project.viewInvoice.InvoiceDto;
import com.enniyal.enniyal_project.viewInvoice.InvoiceService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/invoice"})
public class InvoiceController {
    @Autowired
    private InvoiceService invoiceService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Invoice> createInvoice(@RequestBody InvoiceDto request) {
        try {
            return this.invoiceService.createInvoice(request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create Invoice" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Invoice>> findAll() {
        try {
            return this.invoiceService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred find all Invoice" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<InvoiceDto> findById(@RequestParam Long id) {
        try {
            return this.invoiceService.findById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Invoice id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Invoice> updateById(@RequestParam Long id, @RequestBody InvoiceDto request) {
        try {
            return this.invoiceService.updateById(id, request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by Invoice id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Invoice> deleteById(@RequestParam Long id) {
        try {
            return this.invoiceService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Invoice id" + e.getMessage()));
        }
    }
}

