/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.viewAttandance;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.viewAttandance.ViewAttandance;
import com.enniyal.enniyal_project.viewAttandance.ViewAttandanceDao;
import com.enniyal.enniyal_project.viewAttandance.ViewAttandanceDto;
import com.enniyal.enniyal_project.viewAttandance.ViewAttandanceService;
import com.enniyal.enniyal_project.viewAttandance.ViewAttandanceValidation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ViewAttandanceServiceImpl
implements ViewAttandanceService {
    @Autowired
    private ViewAttandanceDao attandanceDao;
    private final ViewAttandanceValidation viewAttandanceValidation;

    public ApplicationResponse<ViewAttandance> createAttandance(ViewAttandanceDto request) {
        try {
            this.viewAttandanceValidation.validationRequest(request);
            ViewAttandance attandance = this.mapRequestToEntity(request);
            ViewAttandance attand = this.attandanceDao.createAttandance(attandance);
            return ApplicationResponse.success((String)"Successfully create attandance", (Object)attand);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create attandance" + e.getMessage()));
        }
    }

    private ViewAttandance mapRequestToEntity(ViewAttandanceDto request) {
        return ViewAttandance.builder().employeeid(request.getEmployeeid()).employeename(request.getEmployeename()).totalpresent(request.getTotalpresent()).sunday(request.getSunday()).monday(request.getMonday()).tuesday(request.getTuesday()).wednesday(request.getWednesday()).thursday(request.getThursday()).friday(request.getFriday()).saturday(request.getSaturday()).build();
    }

    public ApplicationResponse<List<ViewAttandance>> findAll() {
        try {
            List attandances = this.attandanceDao.findAll();
            return ApplicationResponse.success((String)"Successfully find all attandance", (Object)attandances);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all attandance" + e.getMessage()));
        }
    }

    public ApplicationResponse<ViewAttandanceDto> findByAttandanceId(Long id) {
        try {
            Optional optional = this.attandanceDao.findByAttandanceId(id);
            if (optional.isPresent()) {
                ViewAttandanceDto attandanceDto = this.mapEntityToDto((ViewAttandance)optional.get());
                return ApplicationResponse.success((String)"find by Attandance id is succefully", (Object)attandanceDto);
            }
            return ApplicationResponse.error((String)"Attandance id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Attandance id" + e.getMessage()));
        }
    }

    private ViewAttandanceDto mapEntityToDto(ViewAttandance attandance) {
        return ViewAttandanceDto.builder().id(attandance.getId()).employeeid(attandance.getEmployeeid()).employeename(attandance.getEmployeename()).totalpresent(attandance.getTotalpresent()).sunday(attandance.getSunday()).monday(attandance.getMonday()).tuesday(attandance.getTuesday()).wednesday(attandance.getWednesday()).thursday(attandance.getThursday()).friday(attandance.getFriday()).saturday(attandance.getSaturday()).build();
    }

    public ApplicationResponse<ViewAttandance> updateById(Long id, ViewAttandanceDto request) {
        try {
            Optional optional = this.attandanceDao.findByAttandanceId(id);
            ViewAttandance attandance = (ViewAttandance)optional.get();
            this.updateEntityFromReqest(attandance, request);
            ViewAttandance attand = this.attandanceDao.updateById(attandance);
            return ApplicationResponse.success((String)"succefully update by Attandance id ", (Object)attand);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by Attandance id" + e.getMessage()));
        }
    }

    private void updateEntityFromReqest(ViewAttandance attandance, ViewAttandanceDto request) {
        if (request.getEmployeeid() != null) {
            attandance.setEmployeeid(request.getEmployeeid());
        }
        if (request.getEmployeename() != null) {
            attandance.setEmployeename(request.getEmployeename());
        }
        if (request.getTotalpresent() != null) {
            attandance.setTotalpresent(request.getTotalpresent());
        }
        if (request.getSunday() != null) {
            attandance.setSunday(request.getSunday());
        }
        if (request.getMonday() != null) {
            attandance.setMonday(request.getMonday());
        }
        if (request.getTuesday() != null) {
            attandance.setTuesday(request.getTuesday());
        }
        if (request.getWednesday() != null) {
            attandance.setWednesday(request.getWednesday());
        }
        if (request.getThursday() != null) {
            attandance.setThursday(request.getThursday());
        }
        if (request.getFriday() != null) {
            attandance.setFriday(request.getFriday());
        }
        if (request.getSaturday() != null) {
            attandance.setSaturday(request.getSaturday());
        }
    }

    public ApplicationResponse<ViewAttandance> deleteById(Long id) {
        try {
            this.attandanceDao.deleteById(id);
            return ApplicationResponse.success((String)"Attandance id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Attandance id" + e.getMessage()));
        }
    }

    @Generated
    public ViewAttandanceServiceImpl(ViewAttandanceValidation viewAttandanceValidation) {
        this.viewAttandanceValidation = viewAttandanceValidation;
    }
}

