/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.vendor;

import com.enniyal.enniyal_project.exception.ValidationException;
import com.enniyal.enniyal_project.vendor.VendorDto;
import org.springframework.stereotype.Service;

@Service
public class VendorValidation {
    public void validationRequest(VendorDto vendorDto) {
        if (vendorDto == null) {
            throw new ValidationException("vendorDto is cannot be null");
        }
        if (vendorDto.getName() == null || vendorDto.getName().isEmpty()) {
            throw new ValidationException("name is required");
        }
        if (vendorDto.getCompanyname() == null || vendorDto.getCompanyname().isEmpty()) {
            throw new ValidationException("companyname is required");
        }
        if (vendorDto.getContactnumber() == null || !this.isValidContactNumber(vendorDto.getContactnumber())) {
            throw new ValidationException("ContactNumber is required");
        }
        if (vendorDto.getEmail() == null || !this.isValidEmail(vendorDto.getEmail())) {
            throw new ValidationException("email is required");
        }
        if (vendorDto.getGstno() == null || vendorDto.getGstno().isEmpty()) {
            throw new ValidationException("gstno is required");
        }
        if (vendorDto.getCinno() == null || vendorDto.getCinno().isEmpty()) {
            throw new ValidationException("cinno is required");
        }
        if (vendorDto.getPostalcode() == null || vendorDto.getPostalcode().isEmpty()) {
            throw new ValidationException("getPostalcode is required");
        }
        if (vendorDto.getAddress() == null || vendorDto.getAddress().isEmpty()) {
            throw new ValidationException("address is required");
        }
    }

    private boolean isValidContactNumber(String contactnumber) {
        return contactnumber.matches("^[0-9]{10}$");
    }

    private boolean isValidEmail(String email) {
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }
}

