/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.vendor;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.vendor.Vendor;
import com.enniyal.enniyal_project.vendor.VendorDao;
import com.enniyal.enniyal_project.vendor.VendorDto;
import com.enniyal.enniyal_project.vendor.VendorService;
import com.enniyal.enniyal_project.vendor.VendorValidation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VendorServiceImpl
implements VendorService {
    @Autowired
    private VendorDao vendorDao;
    private final VendorValidation vendorValidation;

    public ApplicationResponse<Vendor> createVendor(VendorDto request) {
        try {
            this.vendorValidation.validationRequest(request);
            Optional optional = this.vendorDao.findByEmail(request.getEmail());
            if (optional.isPresent()) {
                return ApplicationResponse.error((String)(request.getEmail() + "=This email id is already present"));
            }
            Vendor vendor = this.mapRequestToEntity(request);
            Vendor model = this.vendorDao.createVendor(vendor);
            return ApplicationResponse.success((String)"Vendor is create successfully", (Object)model);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save vendor" + e.getMessage()));
        }
    }

    private Vendor mapRequestToEntity(VendorDto request) {
        return Vendor.builder().address(request.getAddress()).cinno(request.getCinno()).companyname(request.getCompanyname()).contactnumber(request.getContactnumber()).email(request.getEmail()).gstno(request.getGstno()).name(request.getName()).postalcode(request.getPostalcode()).build();
    }

    public ApplicationResponse<List<Vendor>> findAll() {
        try {
            List list = this.vendorDao.findAll();
            if (list.isEmpty()) {
                return ApplicationResponse.error((String)"vendor is not found");
            }
            return ApplicationResponse.success((String)"find all vendor", (Object)list);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all vendor" + e.getMessage()));
        }
    }

    public ApplicationResponse<VendorDto> findByVendorId(Long id) {
        try {
            Optional optional = this.vendorDao.findByVendorId(id);
            if (optional.isPresent()) {
                VendorDto vendorDto = this.mapEntityToDto((Vendor)optional.get());
                return ApplicationResponse.success((String)"find by vendor id is succefully", (Object)vendorDto);
            }
            return ApplicationResponse.error((String)"vendor id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by vendor id" + e.getMessage()));
        }
    }

    private VendorDto mapEntityToDto(Vendor vendor) {
        return VendorDto.builder().id(vendor.getId()).address(vendor.getAddress()).cinno(vendor.getCinno()).companyname(vendor.getCompanyname()).contactnumber(vendor.getContactnumber()).email(vendor.getEmail()).gstno(vendor.getGstno()).name(vendor.getName()).postalcode(vendor.getPostalcode()).build();
    }

    public ApplicationResponse<Vendor> updateByVendorId(Long id, VendorDto request) {
        try {
            Optional optional = this.vendorDao.findByVendorId(id);
            Vendor vendor = (Vendor)optional.get();
            this.updateEntityFromRequest(vendor, request);
            Vendor model = this.vendorDao.updateByVendorId(vendor);
            return ApplicationResponse.success((String)"Vendor id is update successfully", (Object)model);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by vendor id" + e.getMessage()));
        }
    }

    private void updateEntityFromRequest(Vendor vendor, VendorDto request) {
        if (request.getAddress() != null) {
            vendor.setAddress(request.getAddress());
        }
        if (request.getCinno() != null) {
            vendor.setCinno(request.getCinno());
        }
        if (request.getCompanyname() != null) {
            vendor.setCompanyname(request.getCompanyname());
        }
        if (request.getContactnumber() != null) {
            vendor.setContactnumber(request.getContactnumber());
        }
        if (request.getEmail() != null) {
            vendor.setEmail(request.getEmail());
        }
        if (request.getGstno() != null) {
            vendor.setGstno(request.getGstno());
        }
        if (request.getName() != null) {
            vendor.setName(request.getName());
        }
        if (request.getPostalcode() != null) {
            vendor.setPostalcode(request.getPostalcode());
        }
    }

    public ApplicationResponse<Vendor> deleteById(Long id) {
        try {
            this.vendorDao.deleteById(id);
            return ApplicationResponse.success((String)"vendor id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by vendor id" + e.getMessage()));
        }
    }

    @Generated
    public VendorServiceImpl(VendorValidation vendorValidation) {
        this.vendorValidation = vendorValidation;
    }
}

