/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.vendor;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.vendor.Vendor;
import com.enniyal.enniyal_project.vendor.VendorDto;
import com.enniyal.enniyal_project.vendor.VendorService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/vendor"})
public class VendorController {
    @Autowired
    private VendorService vendorService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Vendor> createVendor(@RequestBody VendorDto request) {
        try {
            return this.vendorService.createVendor(request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create vendor" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Vendor>> findAll() {
        try {
            return this.vendorService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred find all vendor" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<VendorDto> findByVendorId(@RequestParam Long id) {
        try {
            return this.vendorService.findByVendorId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by vendor id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Vendor> updateByVendorId(@RequestParam Long id, @RequestBody VendorDto request) {
        try {
            return this.vendorService.updateByVendorId(id, request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by vendor id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Vendor> deleteById(@RequestParam Long id) {
        try {
            return this.vendorService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by vendor id" + e.getMessage()));
        }
    }
}

