/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.user;

import com.enniyal.enniyal_project.authentication.UserResponse;
import com.enniyal.enniyal_project.exception.ValidationException;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class UserValidation {
    private Set<String> existingEmail;
    private Set<Long> existingMobile;

    public UserValidation(Set<String> existingEmail, Set<Long> existingMobile) {
        this.existingEmail = existingEmail;
        this.existingMobile = existingMobile;
    }

    public void validationRequest(UserResponse userResponse) {
        if (userResponse == null) {
            throw new ValidationException("userResponse cannot be null");
        }
        if (userResponse.getEmail() == null || !this.isValidEmail(userResponse.getEmail())) {
            throw new ValidationException("email is required AND Invalid email address format");
        }
        if (this.existingEmail.contains(userResponse.getEmail())) {
            throw new ValidationException("Email already exists");
        }
        if (userResponse.getMobile() == null || !this.isValidMobile(userResponse.getMobile())) {
            throw new ValidationException("Invalid or missing mobile number");
        }
        if (this.existingMobile.contains(userResponse.getMobile())) {
            throw new ValidationException("mobile already exists");
        }
        if (userResponse.getFirstname() == null || userResponse.getFirstname().isEmpty()) {
            throw new ValidationException("Firstname is required ");
        }
        if (userResponse.getPassword() == null || userResponse.getPassword().isEmpty()) {
            throw new ValidationException("Password is required");
        }
        if (userResponse.getLoginid() == null || userResponse.getLoginid().isEmpty()) {
            throw new ValidationException("Loginid is required");
        }
    }

    private boolean isValidMobile(Long mobile) {
        String phoneRegex = "^[0-9]{10}$";
        return String.valueOf(mobile).matches(phoneRegex);
    }

    private boolean isValidEmail(String email) {
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }
}

