/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.user;

import com.enniyal.enniyal_project.authentication.UserResponse;
import com.enniyal.enniyal_project.exception.ValidationException;
import org.springframework.stereotype.Service;

@Service
public class EnniyalUserValidation {
    public void validateRequest(UserResponse response) {
        if (response == null) {
            throw new ValidationException("Response body cannot be null");
        }
        if (response.getFirstname() == null || response.getFirstname().trim().isEmpty()) {
            throw new ValidationException("First name is required");
        }
        if (response.getEmail() == null || response.getEmail().trim().isEmpty()) {
            throw new ValidationException("Email is required");
        }
        if (!this.isValidEmail(response.getEmail())) {
            throw new ValidationException("Invalid email address format");
        }
        if (response.getMobile() == null || !this.isValidMobile(response.getMobile())) {
            throw new ValidationException("Invalid or missing phone number");
        }
        if (response.getLoginid() == null || response.getLoginid().trim().isEmpty()) {
            throw new ValidationException("Login ID is required");
        }
        if (response.getPassword() == null || response.getPassword().trim().isEmpty()) {
            throw new ValidationException("Password is required");
        }
    }

    private boolean isValidMobile(Long mobile) {
        if (mobile == null) {
            return false;
        }
        String mobileString = String.valueOf(mobile);
        return mobileString.matches("^[0-9]{10}$");
    }

    private boolean isValidEmail(String email) {
        if (email == null) {
            return false;
        }
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }
}

