/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.takeAttandance;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.takeAttandance.TakeAttandance;
import com.enniyal.enniyal_project.takeAttandance.TakeAttandanceDao;
import com.enniyal.enniyal_project.takeAttandance.TakeAttandanceDto;
import com.enniyal.enniyal_project.takeAttandance.TakeAttandanceService;
import com.enniyal.enniyal_project.takeAttandance.TakeAttandanceValidation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TakeAttandanceServiceImpl
implements TakeAttandanceService {
    @Autowired
    private TakeAttandanceDao attandanceDao;
    private TakeAttandanceValidation takeAttandanceValidation;

    public ApplicationResponse<TakeAttandance> createAttandance(TakeAttandanceDto request) {
        try {
            this.takeAttandanceValidation.validationRequest(request);
            TakeAttandance attandance = this.mapRequestToEntity(request);
            TakeAttandance attand = this.attandanceDao.createAttandance(attandance);
            return ApplicationResponse.success((String)"Successfully create attandance", (Object)attand);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create attandance" + e.getMessage()));
        }
    }

    private TakeAttandance mapRequestToEntity(TakeAttandanceDto request) {
        return TakeAttandance.builder().employeename(request.getEmployeename()).employeeid(request.getEmployeeid()).reason(request.getReason()).leavetype(request.getLeavetype()).reasoning(request.getReasoning()).attandanceallpresent(request.getAttandanceallpresent()).build();
    }

    public ApplicationResponse<List<TakeAttandance>> findAll() {
        try {
            List attandances = this.attandanceDao.findAll();
            return ApplicationResponse.success((String)"Successfully find all attandance", (Object)attandances);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all attandance" + e.getMessage()));
        }
    }

    public ApplicationResponse<TakeAttandanceDto> findByAttandanceId(Long id) {
        try {
            Optional optional = this.attandanceDao.findByAttandanceId(id);
            if (optional.isPresent()) {
                TakeAttandanceDto attandanceDto = this.mapEntityToDto((TakeAttandance)optional.get());
                return ApplicationResponse.success((String)"find by Attandance id is succefully", (Object)attandanceDto);
            }
            return ApplicationResponse.error((String)"Attandance id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Attandance id" + e.getMessage()));
        }
    }

    private TakeAttandanceDto mapEntityToDto(TakeAttandance attandance) {
        return TakeAttandanceDto.builder().id(attandance.getId()).employeename(attandance.getEmployeename()).employeeid(attandance.getEmployeeid()).reason(attandance.getReason()).leavetype(attandance.getLeavetype()).reasoning(attandance.getReasoning()).attandanceallpresent(attandance.getAttandanceallpresent()).build();
    }

    public ApplicationResponse<TakeAttandance> updateById(Long id, TakeAttandanceDto request) {
        try {
            Optional optional = this.attandanceDao.findByAttandanceId(id);
            TakeAttandance attandance = (TakeAttandance)optional.get();
            this.updateEntityFromReqest(attandance, request);
            TakeAttandance attand = this.attandanceDao.updateById(attandance);
            return ApplicationResponse.success((String)"succefully update by Attandance id ", (Object)attand);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by Attandance id" + e.getMessage()));
        }
    }

    private void updateEntityFromReqest(TakeAttandance attandance, TakeAttandanceDto request) {
        if (request.getEmployeeid() != null) {
            attandance.setEmployeeid(request.getEmployeeid());
        }
        if (request.getEmployeename() != null) {
            attandance.setEmployeename(request.getEmployeename());
        }
        if (request.getLeavetype() != null) {
            attandance.setLeavetype(request.getLeavetype());
        }
        if (request.getReason() != null) {
            attandance.setReason(request.getReason());
        }
        if (request.getReasoning() != null) {
            attandance.setReasoning(request.getReasoning());
        }
        if (request.getAttandanceallpresent() != null) {
            attandance.setAttandanceallpresent(request.getAttandanceallpresent());
        }
    }

    public ApplicationResponse<TakeAttandance> deleteById(Long id) {
        try {
            this.attandanceDao.deleteById(id);
            return ApplicationResponse.success((String)"Attandance id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Attandance id" + e.getMessage()));
        }
    }

    @Generated
    public TakeAttandanceServiceImpl() {
    }
}

