/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.security;

import com.enniyal.enniyal_project.security.JwtService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthonticationFilter
extends OncePerRequestFilter {
    private final JwtService jwtService;
    private final UserDetailsService userDetailsService;

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        UserDetails userDetails;
        String userEmail;
        String authHeader = request.getHeader("Authorization");
        System.out.println(authHeader);
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String jwt = authHeader.substring(7);
        try {
            userEmail = this.jwtService.extraceUserName(jwt);
        }
        catch (Exception e) {
            this.handleInvalidToken(response);
            return;
        }
        if (userEmail != null && SecurityContextHolder.getContext().getAuthentication() == null && this.jwtService.isTokenValid(jwt, userDetails = this.userDetailsService.loadUserByUsername(userEmail))) {
            UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            authToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void handleInvalidToken(HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        response.setContentType("application/json");
        response.getWriter().write("{\"data\":{\"Message\":\"Token Authentication Failed !!\"}}");
    }

    @Generated
    public JwtAuthonticationFilter(JwtService jwtService, UserDetailsService userDetailsService) {
        this.jwtService = jwtService;
        this.userDetailsService = userDetailsService;
    }
}

