/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.paySlip;

import com.enniyal.enniyal_project.exception.ValidationException;
import com.enniyal.enniyal_project.paySlip.PaySlipDto;
import org.springframework.stereotype.Service;

@Service
public class PaySlipValidation {
    public void validationRequest(PaySlipDto paySlipDto) {
        if (paySlipDto == null) {
            throw new ValidationException("paySlipDto cannot be null");
        }
        if (paySlipDto.getDesignation() == null || paySlipDto.getDesignation().isEmpty()) {
            throw new ValidationException("Designation is required");
        }
        if (paySlipDto.getMobile() == null || !this.isValidMobile(paySlipDto.getMobile())) {
            throw new ValidationException("Mobile number is required");
        }
        if (paySlipDto.getEmail() == null || !this.isValidEmail(paySlipDto.getEmail())) {
            throw new ValidationException("Email is required");
        }
        if (paySlipDto.getDateofjoining() == null || paySlipDto.getDateofjoining().isEmpty()) {
            throw new ValidationException("Date of joining is required");
        }
        if (paySlipDto.getSendtoemail() == null || paySlipDto.getSendtoemail().isEmpty()) {
            throw new ValidationException("sendtoemail is required");
        }
    }

    private boolean isValidMobile(String mobile) {
        String phoneRegex = "^[0-9]{10}$";
        return mobile.matches(phoneRegex);
    }

    private boolean isValidEmail(String email) {
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }
}

