/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.paySlip;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.employee.Employee;
import com.enniyal.enniyal_project.paySlip.PaySlip;
import com.enniyal.enniyal_project.paySlip.PaySlipDao;
import com.enniyal.enniyal_project.paySlip.PaySlipDto;
import com.enniyal.enniyal_project.paySlip.PaySlipService;
import com.enniyal.enniyal_project.paySlip.PaySlipValidation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaySlipServiceImpl
implements PaySlipService {
    @Autowired
    private PaySlipDao paySlipDao;
    private final PaySlipValidation paySlipValidation;

    public ApplicationResponse<PaySlip> createPaySlip(PaySlipDto request) {
        try {
            this.paySlipValidation.validationRequest(request);
            Employee employee = new Employee();
            request.setEmployeeid(employee.getId());
            this.paySlipValidation.validationRequest(request);
            PaySlip paySlip = this.mapRequestToEntity(request);
            PaySlip model = this.paySlipDao.createPaySlip(paySlip);
            return ApplicationResponse.success((String)"PaySlip is create successfully", (Object)model);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save PaySlip" + e.getMessage()));
        }
    }

    private PaySlip mapRequestToEntity(PaySlipDto request) {
        return PaySlip.builder().employeeid(request.getEmployeeid()).designation(request.getDesignation()).mobile(request.getMobile()).email(request.getEmail()).dateofjoining(request.getDateofjoining()).sendtoemail(request.getSendtoemail()).build();
    }

    public ApplicationResponse<List<PaySlip>> findAll() {
        try {
            List list = this.paySlipDao.findAll();
            return ApplicationResponse.success((String)"find all PaySlip", (Object)list);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all PaySlip" + e.getMessage()));
        }
    }

    public ApplicationResponse<PaySlipDto> findById(Long id) {
        try {
            Optional optional = this.paySlipDao.findById(id);
            if (optional.isPresent()) {
                PaySlipDto paySlipDto = this.mapEntityToDto((PaySlip)optional.get());
                return ApplicationResponse.success((String)"find by PaySlip id is succefully", (Object)paySlipDto);
            }
            return ApplicationResponse.error((String)"PaySlip id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by PaySlip id" + e.getMessage()));
        }
    }

    private PaySlipDto mapEntityToDto(PaySlip paySlip) {
        return PaySlipDto.builder().id(paySlip.getId()).designation(paySlip.getDesignation()).mobile(paySlip.getMobile()).email(paySlip.getEmail()).dateofjoining(paySlip.getDateofjoining()).sendtoemail(paySlip.getSendtoemail()).build();
    }

    public ApplicationResponse<PaySlip> updateById(Long id, PaySlipDto request) {
        try {
            Optional optional = this.paySlipDao.findById(id);
            PaySlip paySlip = (PaySlip)optional.get();
            this.updateEntityFromRequest(paySlip, request);
            PaySlip model = this.paySlipDao.updateById(paySlip);
            return ApplicationResponse.success((String)"PaySlip id is update successfully", (Object)model);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by PaySlip id" + e.getMessage()));
        }
    }

    private void updateEntityFromRequest(PaySlip paySlip, PaySlipDto request) {
        if (request.getEmail() != null) {
            paySlip.setEmail(request.getEmail());
        }
        if (request.getDesignation() != null) {
            paySlip.setDesignation(request.getDesignation());
        }
        if (request.getDateofjoining() != null) {
            paySlip.setDateofjoining(request.getDateofjoining());
        }
        if (request.getMobile() != null) {
            paySlip.setMobile(request.getMobile());
        }
        if (request.getSendtoemail() != null) {
            paySlip.setSendtoemail(request.getSendtoemail());
        }
    }

    public ApplicationResponse<PaySlip> deleteById(Long id) {
        try {
            this.paySlipDao.deleteById(id);
            return ApplicationResponse.success((String)"PaySlip id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by PaySlip id" + e.getMessage()));
        }
    }

    @Generated
    public PaySlipServiceImpl(PaySlipValidation paySlipValidation) {
        this.paySlipValidation = paySlipValidation;
    }
}

