/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.paySlip;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.paySlip.PaySlip;
import com.enniyal.enniyal_project.paySlip.PaySlipDto;
import com.enniyal.enniyal_project.paySlip.PaySlipService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/payslip"})
public class PaySlipController {
    @Autowired
    private PaySlipService paySlipService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<PaySlip> createPaySlip(@RequestBody PaySlipDto request) {
        try {
            return this.paySlipService.createPaySlip(request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create PaySlip" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<PaySlip>> findAll() {
        try {
            return this.paySlipService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred find all PaySlip" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<PaySlipDto> findById(@RequestParam Long id) {
        try {
            return this.paySlipService.findById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by payslip id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<PaySlip> updateById(@RequestParam Long id, @RequestBody PaySlipDto request) {
        try {
            return this.paySlipService.updateById(id, request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by PaySlip id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<PaySlip> deleteById(@RequestParam Long id) {
        try {
            return this.paySlipService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by PaySlip id" + e.getMessage()));
        }
    }
}

