/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.password;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.authentication.AuthenticationService;
import com.enniyal.enniyal_project.authentication.UserResponse;
import com.enniyal.enniyal_project.otp.OtpService;
import com.enniyal.enniyal_project.password.PasswordDto;
import com.enniyal.enniyal_project.password.PasswordService;
import com.enniyal.enniyal_project.user.User;
import com.enniyal.enniyal_project.user.UserDao;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class PasswordServiceImpl
implements PasswordService {
    private final AuthenticationService authenticationService;
    private final PasswordEncoder encoder;
    private final OtpService otpService;
    private final UserDao userDao;

    public ApplicationResponse<String> changePassword(PasswordDto passwordDto, String token) {
        try {
            PasswordDto password = this.authenticationService.getPassDetails(token);
            if (!this.encoder.matches((CharSequence)passwordDto.getOldPassword(), password.getOldPassword())) {
                return ApplicationResponse.error((String)"Old Password is incorrect");
            }
            if (!passwordDto.getNewPassword().equals(passwordDto.getReenterPassword())) {
                return ApplicationResponse.error((String)"New password and reenter password do not match");
            }
            Optional userOTP = this.userDao.findById(passwordDto.getId());
            if (userOTP.isEmpty()) {
                return ApplicationResponse.error((String)"User not found");
            }
            User user = (User)userOTP.get();
            String newPassword = passwordDto.getNewPassword();
            user.setPassword(this.encoder.encode((CharSequence)newPassword));
            this.userDao.save(user);
            return ApplicationResponse.success((String)"Password change successfuly", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while change password" + e.getMessage()));
        }
    }

    public ApplicationResponse<String> forgetPassword(UserResponse response) {
        try {
            if (response.getEmail() == null) {
                return ApplicationResponse.error((String)"Email is required");
            }
            Optional user = this.userDao.findByEmail(response.getEmail());
            if (!user.isPresent()) {
                return ApplicationResponse.error((String)"User not found with the provided email");
            }
            if (response.getOtp() == null) {
                return ApplicationResponse.error((String)"OTP is required");
            }
            if (response.getPassword() == null) {
                return ApplicationResponse.error((String)"password is required");
            }
            boolean isverifyOTP = this.otpService.verifyOTP(response.getEmail(), response.getOtp());
            if (!isverifyOTP) {
                return ApplicationResponse.error((String)"Invalid OTP");
            }
            ((User)user.get()).setPassword(this.encoder.encode((CharSequence)response.getPassword()));
            this.userDao.save((User)user.get());
            return ApplicationResponse.success((String)"Password change succefully", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApplicationResponse.error((String)"An unexpected occurred error please try again later");
        }
    }

    @Generated
    public PasswordServiceImpl(AuthenticationService authenticationService, PasswordEncoder encoder, OtpService otpService, UserDao userDao) {
        this.authenticationService = authenticationService;
        this.encoder = encoder;
        this.otpService = otpService;
        this.userDao = userDao;
    }
}

