/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.otp;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.otp.OtpDto;
import com.enniyal.enniyal_project.otp.OtpService;
import com.enniyal.enniyal_project.utils.JavaSendApi;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class OtpServiceImpl {
    private final JavaSendApi javaSendApi;
    private final OtpService otpService;

    public ApplicationResponse<String> sendOtp(OtpDto dto) {
        try {
            System.out.println("Generate otp for account creation");
            String otp = this.otpService.generateOTP();
            System.out.println("OTP generated=" + otp);
            this.otpService.storeOTPInDatabase(dto.getEmail(), otp);
            System.out.println("OTP Stored in database");
            String body = "<html><p>Welcome to Enniyal! To complete your account setup, please use the OTP below:</p><p><strong>Your OTP: " + otp + "</strong></p><p>This OTP is valid for the next 10 minutes. Please enter it on the registration page to verify your email address.</p><p>If you did not request an account with Enniyal, please ignore this email.</p><br><p>Best regards,</p><p>The Enniyal Team</p><p><a href='mailto:support@Enniyal.com'>support@Enniyal.com</a></p><p><a href='https://Enniyal.com'>Enniyal.com</a></p></html>";
            String subject = "Enniyal Account Verification OTP";
            this.javaSendApi.sendMailWithAttachment(dto.getEmail(), body, subject);
            return ApplicationResponse.success((String)"Success", (Object)"OTP has been sent to your email for account creation");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("Something went wrong while sending the OTP." + e.getMessage()));
        }
    }

    public String otpverification(OtpDto dto) {
        try {
            Boolean verified = this.otpService.verifyOTP(dto.getEmail(), dto.getOtp());
            if (verified.booleanValue()) {
                return "Success OTP Vserified successfully.Account creation can procced.info";
            }
            return "Error Invalid OTP.please check verify and try again.info";
        }
        catch (Exception e) {
            return "An error occurred while otp verification.Error";
        }
    }

    @Generated
    public OtpServiceImpl(JavaSendApi javaSendApi, OtpService otpService) {
        this.javaSendApi = javaSendApi;
        this.otpService = otpService;
    }
}

