/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.otp;

import com.enniyal.enniyal_project.otp.OtpData;
import com.enniyal.enniyal_project.otp.OtpRepository;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OtpService {
    private static final SecureRandom RANDOM = new SecureRandom();
    @Autowired
    private OtpRepository otpRepository;

    public boolean otpVerification(String otp, String mobile) {
        String otpCode = this.generateOTP();
        this.storeOTPInDatabase(mobile, otpCode);
        return this.verifyOTP(mobile, otp);
    }

    public String generateOTP() {
        int otpValue = RANDOM.nextInt(900000) + 100000;
        return String.valueOf(otpValue);
    }

    public void storeOTPInDatabase(String mobile, String otpCode) {
        OtpData otpData = this.otpRepository.findByMobile(mobile);
        if (otpData != null) {
            otpData.setOtpcode(otpCode);
            otpData.setExpiresAt(Timestamp.from(Instant.now().plusSeconds(600L)));
            otpData.setVerified(Boolean.valueOf(false));
        } else {
            otpData = OtpData.builder().mobile(mobile).otpcode(otpCode).expiresAt(Timestamp.from(Instant.now().plusSeconds(600L))).verified(Boolean.valueOf(false)).build();
        }
        this.otpRepository.save((Object)otpData);
    }

    public boolean verifyOTP(String mobile, String receivedOtp) {
        OtpData otpData = this.otpRepository.findByMobile(mobile);
        if (otpData != null) {
            String storedOtp = otpData.getOtpcode();
            Timestamp expirationTime = otpData.getExpiresAt();
            if (!otpData.getVerified().booleanValue() && storedOtp.equals(receivedOtp) && Instant.now().isBefore(expirationTime.toInstant())) {
                otpData.setVerified(Boolean.valueOf(true));
                this.otpRepository.save((Object)otpData);
                return true;
            }
        }
        return false;
    }

    public void resendOTP(String mobile) {
        String newOtpCode = this.generateOTP();
        this.storeOTPInDatabase(mobile, newOtpCode);
        System.out.println("New OTP: " + newOtpCode);
    }

    public void deleteOTP(String mobile) {
        OtpData otpData = this.otpRepository.findByMobile(mobile);
        if (otpData != null) {
            this.otpRepository.delete((Object)otpData);
        }
    }
}

