/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.expancess;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.expancess.Expancess;
import com.enniyal.enniyal_project.expancess.ExpancessDao;
import com.enniyal.enniyal_project.expancess.ExpancessDto;
import com.enniyal.enniyal_project.expancess.ExpancessService;
import com.enniyal.enniyal_project.expancess.ExpancessValidation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExpancessServiceImpl
implements ExpancessService {
    @Autowired
    private ExpancessDao expancessDao;
    private final ExpancessValidation expancessValidation;

    public ApplicationResponse<Expancess> createExpancess(ExpancessDto request) {
        try {
            this.expancessValidation.validationRequest(request);
            Expancess expancess = this.mapRequestToEntity(request);
            if (request.getUploadfile() == null) {
                expancess.setUploadfile("https://storage.megashop.my/FindClub/16112024213328714.jpeg");
            }
            Expancess expance = this.expancessDao.createExpancess(expancess);
            return ApplicationResponse.success((String)"Expancess is create successfully", (Object)expance);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create expancess" + e.getMessage()));
        }
    }

    private Expancess mapRequestToEntity(ExpancessDto request) {
        return Expancess.builder().date(request.getDate()).invoicenumber(request.getInvoicenumber()).modeofpayment(request.getModeofpayment()).payfor(request.getPayfor()).payto(request.getPayto()).pending(request.getPending()).uploadfile(request.getUploadfile()).totalpay(request.getTotalpay()).build();
    }

    public ApplicationResponse<List<Expancess>> findAll() {
        try {
            List expancesses = this.expancessDao.findAll();
            return ApplicationResponse.success((String)" find all Expancess", (Object)expancesses);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all expancess" + e.getMessage()));
        }
    }

    public ApplicationResponse<ExpancessDto> findByExpancessId(Long id) {
        try {
            Optional optional = this.expancessDao.findByExpancessId(id);
            if (optional.isPresent()) {
                ExpancessDto expancessDto = this.mapEntityToDto((Expancess)optional.get());
                return ApplicationResponse.success((String)"successfully find by expancess id", (Object)expancessDto);
            }
            return ApplicationResponse.error((String)"expancess id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by expancess id" + e.getMessage()));
        }
    }

    private ExpancessDto mapEntityToDto(Expancess expancess) {
        return ExpancessDto.builder().id(expancess.getId()).date(expancess.getDate()).invoicenumber(expancess.getInvoicenumber()).modeofpayment(expancess.getModeofpayment()).payfor(expancess.getPayfor()).payto(expancess.getPayto()).pending(expancess.getPending()).uploadfile(expancess.getUploadfile()).totalpay(expancess.getTotalpay()).build();
    }

    public ApplicationResponse<Expancess> updateByExpancessId(Long id, ExpancessDto request) {
        try {
            Optional optional = this.expancessDao.findByExpancessId(id);
            Expancess expancess = (Expancess)optional.get();
            this.updateEntityFromRequest(expancess, request);
            Expancess expance = this.expancessDao.createExpancess(expancess);
            return ApplicationResponse.success((String)"successfully update by expancess id", (Object)expance);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by expancess id" + e.getMessage()));
        }
    }

    private void updateEntityFromRequest(Expancess expancess, ExpancessDto request) {
        if (request.getDate() != null) {
            expancess.setDate(request.getDate());
        }
        if (request.getInvoicenumber() != null) {
            expancess.setInvoicenumber(request.getInvoicenumber());
        }
        if (request.getModeofpayment() != null) {
            expancess.setModeofpayment(request.getModeofpayment());
        }
        if (request.getPayfor() != null) {
            expancess.setPayfor(request.getPayfor());
        }
        if (request.getPayto() != null) {
            expancess.setPayto(request.getPayto());
        }
        if (request.getPending() != null) {
            expancess.setPending(request.getPending());
        }
        if (request.getTotalpay() != null) {
            expancess.setTotalpay(request.getTotalpay());
        }
        if (request.getUploadfile() != null) {
            expancess.setUploadfile(request.getUploadfile());
        }
    }

    public ApplicationResponse<Expancess> deleteById(Long id) {
        try {
            this.expancessDao.deleteById(id);
            return ApplicationResponse.success((String)"successfully delete by expancess id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by expancess id" + e.getMessage()));
        }
    }

    @Generated
    public ExpancessServiceImpl(ExpancessValidation expancessValidation) {
        this.expancessValidation = expancessValidation;
    }
}

