/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.employee;

import com.enniyal.enniyal_project.employee.EmployeeDto;
import com.enniyal.enniyal_project.exception.ValidationException;
import org.springframework.stereotype.Service;

@Service
public class EmployeeValidation {
    public void validationRequest(EmployeeDto employeeDto) {
        if (employeeDto == null) {
            throw new ValidationException("employeeDto cannot be null");
        }
        if (employeeDto.getName() == null || employeeDto.getName().isEmpty()) {
            throw new ValidationException("employee name is required");
        }
        if (employeeDto.getGender() == null || employeeDto.getGender().isEmpty()) {
            throw new ValidationException("gender is required");
        }
        if (employeeDto.getEmployeeid() == null) {
            throw new ValidationException("employee id is required");
        }
        if (employeeDto.getEmail() == null || !this.isValidEmail(employeeDto.getEmail())) {
            throw new ValidationException("email is required AND Invalid email address format");
        }
        if (employeeDto.getContactnumber() == null || !this.isValidContactNumber(employeeDto.getContactnumber())) {
            throw new ValidationException("Invalid or missing mobile number");
        }
        if (employeeDto.getDesignation() == null || employeeDto.getDesignation().isEmpty()) {
            throw new ValidationException("Designation is required");
        }
        if (employeeDto.getBloodgroup() == null || employeeDto.getBloodgroup().isEmpty()) {
            throw new ValidationException("blood group is required");
        }
        if (employeeDto.getBankname() == null || employeeDto.getBankname().isEmpty()) {
            throw new ValidationException("bank name is required");
        }
        if (employeeDto.getBranchname() == null || employeeDto.getBranchname().isEmpty()) {
            throw new ValidationException("branch name is required");
        }
        if (employeeDto.getAccountnumber() == null || employeeDto.getAccountnumber().isEmpty()) {
            throw new ValidationException("account number is required");
        }
        if (employeeDto.getIfsccode() == null || employeeDto.getIfsccode().isEmpty()) {
            throw new ValidationException("ifsc code is required");
        }
    }

    private boolean isValidContactNumber(Long contactnumber) {
        String phoneRegex = "^[0-9]{10}$";
        return String.valueOf(contactnumber).matches(phoneRegex);
    }

    private boolean isValidEmail(String email) {
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }
}

