/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.employee;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.employee.Employee;
import com.enniyal.enniyal_project.employee.EmployeeDao;
import com.enniyal.enniyal_project.employee.EmployeeDto;
import com.enniyal.enniyal_project.employee.EmployeeService;
import com.enniyal.enniyal_project.employee.EmployeeValidation;
import com.enniyal.enniyal_project.user.Role;
import com.enniyal.enniyal_project.user.User;
import com.enniyal.enniyal_project.user.UserDao;
import com.enniyal.enniyal_project.user.UserRepository;
import com.enniyal.enniyal_project.utils.JavaSendApi;
import java.security.SecureRandom;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class EmployeeServiceImpl
implements EmployeeService {
    @Autowired
    private EmployeeDao employeeDao;
    private final UserRepository userRepository;
    private final EmployeeValidation employeeValidation;
    private final UserDao userDao;
    private final JavaSendApi javaSendApi;

    public ApplicationResponse<Employee> createEmployee(EmployeeDto request) {
        try {
            this.employeeValidation.validationRequest(request);
            Optional optional = this.employeeDao.findByEmail(request.getEmail());
            if (optional.isPresent()) {
                return ApplicationResponse.error((String)"This email id is already present");
            }
            Optional empOptional = this.employeeDao.findByContactnumber(request.getContactnumber());
            if (empOptional.isPresent()) {
                return ApplicationResponse.error((String)"This mobile number is already present");
            }
            if (this.userDao.findByEmail(request.getEmail()).isPresent()) {
                return ApplicationResponse.error((String)(request.getEmail() + " = This email ID is already present in User table"));
            }
            if (this.userDao.findByMobile(request.getContactnumber()).isPresent()) {
                return ApplicationResponse.error((String)(request.getContactnumber() + " = This mobile number is already present in User table"));
            }
            Employee employee = this.mapRequestToEentity(request);
            if (request.getEmployeeimage() == null) {
                employee.setEmployeeimage("https://storage.megashop.my/FindClub/16112024213328714.jpeg");
            }
            Employee employ = this.employeeDao.createEmployee(employee);
            String rawPassword = this.generateRandomPassword(10);
            BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
            String hashedPassword = encoder.encode((CharSequence)rawPassword);
            User user = new User();
            user.setEmployeeid(employ.getId());
            user.setPassword(hashedPassword);
            user.setEmail(employ.getEmail());
            user.setMobile(employ.getContactnumber());
            user.setFirstname(employ.getName());
            user.setRole(Role.USER);
            user.setStatus(Boolean.valueOf(true));
            this.userRepository.save((Object)user);
            String To_mail = employ.getEmail();
            String Subject = "Welcome to Joliass !";
            String body = "<html><body style='font-family: Arial, sans-serif; font-size: 14px; color: #333;'><p>Dear " + employ.getName() + ",</p><p>Your account has been <strong>successfully created</strong>. Below are your login credentials:</p><table style='border-collapse: collapse; width: 100%; max-width: 400px;'>  <tr>    <td style='padding: 8px; border: 1px solid #ddd; background-color: #f4f4f4;'><strong>Login ID:</strong></td>    <td style='padding: 8px; border: 1px solid #ddd;'>" + employ.getEmail() + "</td>  </tr>  <tr>    <td style='padding: 8px; border: 1px solid #ddd; background-color: #f4f4f4;'><strong>Password:</strong></td>    <td style='padding: 8px; border: 1px solid #ddd;'>" + rawPassword + "</td>  </tr></table><p><strong>Please keep this information secure</strong> and do not share it with anyone.</p><p>If you have any questions or need assistance, feel free to contact our support team.</p><p>Best regards,</p><p><strong>The Joliass Team</strong></p><p><a href='mailto:noreply@riotinfomedia.com'>noreply@riotinfomedia.com</a></p><p><a href='https://joliass.com' target='_blank'>joliass.com</a></p></body></html>";
            this.javaSendApi.sendMailWithAttachment(To_mail, body, Subject);
            return ApplicationResponse.success((String)"Employee is create successfully", (Object)employ);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save employee" + e.getMessage()));
        }
    }

    private String generateRandomPassword(int length) {
        String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()-_";
        SecureRandom random = new SecureRandom();
        StringBuilder password = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            password.append(CHARACTERS.charAt(random.nextInt(CHARACTERS.length())));
        }
        return password.toString();
    }

    private Employee mapRequestToEentity(EmployeeDto request) {
        return Employee.builder().name(request.getName()).employeeimage(request.getEmployeeimage()).gender(request.getGender()).dateofbirth(request.getDateofbirth()).employeeid(request.getEmployeeid()).email(request.getEmail()).contactnumber(request.getContactnumber()).dateofjoining(request.getDateofjoining()).designation(request.getDesignation()).bloodgroup(request.getBloodgroup()).bankname(request.getBankname()).branchname(request.getBranchname()).accountnumber(request.getAccountnumber()).ifsccode(request.getIfsccode()).status(Boolean.valueOf(true)).build();
    }

    public ApplicationResponse<List<Employee>> findAll() {
        try {
            List employees = this.employeeDao.findAll();
            if (employees.isEmpty()) {
                return ApplicationResponse.error((String)"Employee is not found");
            }
            return ApplicationResponse.success((String)" find all Employee", (Object)employees);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all employee" + e.getMessage()));
        }
    }

    public ApplicationResponse<EmployeeDto> findById(Long id) {
        try {
            Optional optional = this.employeeDao.findById(id);
            if (optional.isPresent()) {
                EmployeeDto employeeDto = this.mapEntityToDto((Employee)optional.get());
                return ApplicationResponse.success((String)"find by Employee id is succefully", (Object)employeeDto);
            }
            return ApplicationResponse.error((String)"Employee id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Employee id" + e.getMessage()));
        }
    }

    private EmployeeDto mapEntityToDto(Employee employee) {
        return EmployeeDto.builder().id(employee.getId()).name(employee.getName()).employeeimage(employee.getEmployeeimage()).gender(employee.getGender()).dateofbirth(employee.getDateofbirth()).employeeid(employee.getEmployeeid()).email(employee.getEmail()).contactnumber(employee.getContactnumber()).dateofjoining(employee.getDateofjoining()).designation(employee.getDesignation()).bloodgroup(employee.getBloodgroup()).bankname(employee.getBankname()).branchname(employee.getBranchname()).accountnumber(employee.getAccountnumber()).ifsccode(employee.getIfsccode()).status(Boolean.valueOf(true)).build();
    }

    public ApplicationResponse<Employee> updateById(Long id, EmployeeDto request) {
        try {
            Optional optional = this.employeeDao.findById(id);
            Employee employee = (Employee)optional.get();
            this.updateEntityFromRequest(employee, request);
            Employee model = this.employeeDao.updateById(employee);
            return ApplicationResponse.success((String)"employee id is update successfully", (Object)model);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by employee id" + e.getMessage()));
        }
    }

    private void updateEntityFromRequest(Employee employee, EmployeeDto request) {
        if (request.getName() != null) {
            employee.setName(request.getName());
        }
        if (request.getEmployeeimage() != null) {
            employee.setEmployeeimage(request.getEmployeeimage());
        }
        if (request.getGender() != null) {
            employee.setGender(request.getGender());
        }
        if (request.getDateofbirth() != null) {
            employee.setDateofbirth(request.getDateofbirth());
        }
        if (request.getEmployeeid() != null) {
            employee.setEmployeeid(request.getEmployeeid());
        }
        if (request.getEmail() != null) {
            employee.setEmail(request.getEmail());
        }
        if (request.getContactnumber() != null) {
            employee.setContactnumber(request.getContactnumber());
        }
        if (request.getDateofjoining() != null) {
            employee.setDateofjoining(request.getDateofjoining());
        }
        if (request.getDesignation() != null) {
            employee.setDesignation(request.getDesignation());
        }
        if (request.getStatus() != null) {
            employee.setStatus(Boolean.valueOf(true));
        }
        if (request.getBloodgroup() != null) {
            employee.setBloodgroup(request.getBloodgroup());
        }
        if (request.getBankname() != null) {
            employee.setBankname(request.getBankname());
        }
        if (request.getBranchname() != null) {
            employee.setBranchname(request.getBranchname());
        }
        if (request.getAccountnumber() != null) {
            employee.setAccountnumber(request.getAccountnumber());
        }
        if (request.getIfsccode() != null) {
            employee.setIfsccode(request.getIfsccode());
        }
    }

    public ApplicationResponse<Employee> deleteById(Long id) {
        try {
            Optional optional = this.userRepository.findByEmployeeid(id);
            User user = (User)optional.get();
            this.userDao.deleteByEmployeeid(user.getId());
            this.employeeDao.deleteById(id);
            return ApplicationResponse.success((String)"Employee id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Employee id" + e.getMessage()));
        }
    }

    @Generated
    public EmployeeServiceImpl(UserRepository userRepository, EmployeeValidation employeeValidation, UserDao userDao, JavaSendApi javaSendApi) {
        this.userRepository = userRepository;
        this.employeeValidation = employeeValidation;
        this.userDao = userDao;
        this.javaSendApi = javaSendApi;
    }
}

