/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.employee;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.employee.Employee;
import com.enniyal.enniyal_project.employee.EmployeeDto;
import com.enniyal.enniyal_project.employee.EmployeeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/employee"})
public class EmployeeController {
    @Autowired
    private EmployeeService employeeService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Employee> createEmployee(@RequestBody EmployeeDto request) {
        try {
            return this.employeeService.createEmployee(request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create Employee" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Employee>> findAll() {
        try {
            return this.employeeService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred find all Employee" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<EmployeeDto> findById(@RequestParam Long id) {
        try {
            return this.employeeService.findById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Employee id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Employee> updateById(@RequestParam Long id, @RequestBody EmployeeDto request) {
        try {
            return this.employeeService.updateById(id, request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by Employee id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Employee> deleteById(@RequestParam Long id) {
        try {
            return this.employeeService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Employee id" + e.getMessage()));
        }
    }
}

