/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.designation;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.designation.Designation;
import com.enniyal.enniyal_project.designation.DesignationDao;
import com.enniyal.enniyal_project.designation.DesignationDto;
import com.enniyal.enniyal_project.designation.DesignationService;
import com.enniyal.enniyal_project.designation.DesignationValidation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DesignationServiceImpl
implements DesignationService {
    @Autowired
    private DesignationDao designationDao;
    private final DesignationValidation designationValidation;

    public ApplicationResponse<Designation> createDesignation(DesignationDto request) {
        try {
            this.designationValidation.validationRequest(request);
            Designation designation = this.mapRequestToEntity(request);
            if (this.designationDao.existsByDesignation(request.getDesignation())) {
                return ApplicationResponse.error((String)(request.getDesignation() + " = This designation is already present"));
            }
            Designation design = this.designationDao.createDesignation(designation);
            return ApplicationResponse.success((String)"Designstion is created successfully", (Object)design);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create designation" + e.getMessage()));
        }
    }

    private Designation mapRequestToEntity(DesignationDto request) {
        return Designation.builder().designation(request.getDesignation()).build();
    }

    public ApplicationResponse<List<Designation>> getAll() {
        try {
            List designations = this.designationDao.getAll();
            return ApplicationResponse.success((String)"find all designation successfully", (Object)designations);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all designation" + e.getMessage()));
        }
    }

    public ApplicationResponse<DesignationDto> findByDesignationId(Long id) {
        try {
            Optional optional = this.designationDao.findByDesignationId(id);
            if (optional.isPresent()) {
                DesignationDto designationDto = this.mapEntityToDto((Designation)optional.get());
                return ApplicationResponse.success((String)"Designation id is find successfully", (Object)designationDto);
            }
            return ApplicationResponse.error((String)"Desination id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by designation id" + e.getMessage()));
        }
    }

    private DesignationDto mapEntityToDto(Designation designation) {
        return DesignationDto.builder().id(designation.getId()).designation(designation.getDesignation()).build();
    }

    public ApplicationResponse<Designation> updateByDesignationId(Long id, DesignationDto request) {
        try {
            Optional optional = this.designationDao.findByDesignationId(id);
            Designation designation = (Designation)optional.get();
            this.updateEntityFromRequest(designation, request);
            Designation design = this.designationDao.updateByDesignationId(designation);
            return ApplicationResponse.success((String)"Designation id is update successfully", (Object)design);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by designation id" + e.getMessage()));
        }
    }

    private void updateEntityFromRequest(Designation designation, DesignationDto request) {
        if (request.getDesignation() != null) {
            designation.setDesignation(request.getDesignation());
        }
    }

    public ApplicationResponse<Designation> deleteById(Long id) {
        try {
            this.designationDao.deleteById(id);
            return ApplicationResponse.success((String)"Designation id is delete successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by designation id" + e.getMessage()));
        }
    }

    @Generated
    public DesignationServiceImpl(DesignationValidation designationValidation) {
        this.designationValidation = designationValidation;
    }
}

