/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.designation;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.designation.Designation;
import com.enniyal.enniyal_project.designation.DesignationDto;
import com.enniyal.enniyal_project.designation.DesignationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/designation"})
public class DesignationController {
    @Autowired
    private DesignationService designationService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Designation> createDesignation(@RequestBody DesignationDto request) {
        try {
            return this.designationService.createDesignation(request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create designation" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Designation>> getAll() {
        try {
            return this.designationService.getAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all designation" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<DesignationDto> findByDesignationId(@RequestParam Long id) {
        try {
            return this.designationService.findByDesignationId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by designation id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Designation> updateByDesignationId(@RequestParam Long id, @RequestBody DesignationDto request) {
        try {
            return this.designationService.updateByDesignationId(id, request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by designation id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Designation> deleteById(@RequestParam Long id) {
        try {
            return this.designationService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by designation id" + e.getMessage()));
        }
    }
}

