/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.companyProfile;

import com.enniyal.enniyal_project.companyProfile.ProfileDto;
import com.enniyal.enniyal_project.exception.ValidationException;
import org.springframework.stereotype.Service;

@Service
public class ProfileValidation {
    public void validationRequest(ProfileDto profileDto) {
        if (profileDto == null) {
            throw new ValidationException("profileDto cannot be null");
        }
        if (profileDto.getCompanyname() == null || profileDto.getCompanyname().isEmpty()) {
            throw new ValidationException("company name is required");
        }
        if (profileDto.getMobilenumber() == null || !this.isValidMobile(profileDto.getMobilenumber())) {
            throw new ValidationException("Invalid or missing mobile number");
        }
        if (profileDto.getEmail() == null || !this.isValidEmail(profileDto.getEmail())) {
            throw new ValidationException("Invalid email address format");
        }
        if (profileDto.getWebsiteaddress() == null || profileDto.getWebsiteaddress().isEmpty()) {
            throw new ValidationException("website address required");
        }
        if (profileDto.getGstnumber() == null || profileDto.getGstnumber().isEmpty()) {
            throw new ValidationException(" GST number required");
        }
        if (profileDto.getCinnumber() == null || profileDto.getCinnumber().isEmpty()) {
            throw new ValidationException(" CIN number required");
        }
        if (profileDto.getAddress1() == null || profileDto.getAddress1().trim().isEmpty()) {
            throw new ValidationException("Address1 is required");
        }
        if (profileDto.getCity() == null || profileDto.getCity().trim().isEmpty()) {
            throw new ValidationException("City is required");
        }
        if (profileDto.getState() == null || profileDto.getState().trim().isEmpty()) {
            throw new ValidationException("State is required");
        }
        if (profileDto.getCountry() == null || profileDto.getCountry().trim().isEmpty()) {
            throw new ValidationException("Country is required");
        }
        if (profileDto.getPincode() == null || profileDto.getPincode().isEmpty()) {
            throw new ValidationException(" pincode is required");
        }
        if (profileDto.getPrimarycurrency() == null || profileDto.getPrimarycurrency().isEmpty()) {
            throw new ValidationException("Primarycurrency is required");
        }
        if (profileDto.getSecondarycurrency() == null || profileDto.getSecondarycurrency().isEmpty()) {
            throw new ValidationException("Secondarycurrency is required");
        }
    }

    private boolean isValidEmail(String email) {
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }

    private boolean isValidMobile(String mobile) {
        return mobile.matches("^[0-9]{10}$");
    }
}

