/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.companyProfile;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.companyProfile.Profile;
import com.enniyal.enniyal_project.companyProfile.ProfileDao;
import com.enniyal.enniyal_project.companyProfile.ProfileDto;
import com.enniyal.enniyal_project.companyProfile.ProfileService;
import com.enniyal.enniyal_project.companyProfile.ProfileValidation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProfileServiceImpl
implements ProfileService {
    @Autowired
    private ProfileDao profileDao;
    private final ProfileValidation profileValidation;

    public ApplicationResponse<Profile> createProfile(ProfileDto request) {
        try {
            this.profileValidation.validationRequest(request);
            Optional optional = this.profileDao.findByEmail(request.getEmail());
            if (optional.isPresent()) {
                return ApplicationResponse.error((String)(request.getEmail() + "=This email id is already present"));
            }
            Profile profile = this.mapRequestToEntity(request);
            if (request.getCompanylogo() == null) {
                profile.setCompanylogo("https://storage.megashop.my/FindClub/16112024213328714.jpeg");
            }
            Profile model = this.profileDao.createProfile(profile);
            return ApplicationResponse.success((String)"Profile is create successfully", (Object)model);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save Profile" + e.getMessage()));
        }
    }

    private Profile mapRequestToEntity(ProfileDto request) {
        return Profile.builder().companylogo(request.getCompanylogo()).companyname(request.getCompanyname()).mobilenumber(request.getMobilenumber()).email(request.getEmail()).websiteaddress(request.getWebsiteaddress()).gstnumber(request.getGstnumber()).cinnumber(request.getCinnumber()).primarycurrency(request.getPrimarycurrency()).secondarycurrency(request.getSecondarycurrency()).address1(request.getAddress1()).address2(request.getAddress2()).city(request.getCity()).state(request.getState()).country(request.getCountry()).pincode(request.getPincode()).cgst(request.getCgst()).sgst(request.getSgst()).notes(request.getNotes()).build();
    }

    public ApplicationResponse<List<Profile>> findAll() {
        try {
            List lists = this.profileDao.findAll();
            if (lists.isEmpty()) {
                return ApplicationResponse.error((String)"profile id is not found");
            }
            return ApplicationResponse.success((String)"find all Profile", (Object)lists);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all Profile" + e.getMessage()));
        }
    }

    public ApplicationResponse<ProfileDto> findById(Long id) {
        try {
            Optional optional = this.profileDao.findById(id);
            if (optional.isPresent()) {
                ProfileDto profileDto = this.mapEntityToDto((Profile)optional.get());
                return ApplicationResponse.success((String)"find by Profile id is succefully", (Object)profileDto);
            }
            return ApplicationResponse.error((String)"Profile id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Profile id" + e.getMessage()));
        }
    }

    private ProfileDto mapEntityToDto(Profile profile) {
        return ProfileDto.builder().id(profile.getId()).companylogo(profile.getCompanylogo()).companyname(profile.getCompanyname()).mobilenumber(profile.getMobilenumber()).email(profile.getEmail()).websiteaddress(profile.getWebsiteaddress()).gstnumber(profile.getGstnumber()).cinnumber(profile.getCinnumber()).primarycurrency(profile.getPrimarycurrency()).secondarycurrency(profile.getSecondarycurrency()).cgst(profile.getCgst()).sgst(profile.getSgst()).address1(profile.getAddress1()).address2(profile.getAddress2()).city(profile.getCity()).state(profile.getState()).country(profile.getCountry()).pincode(profile.getPincode()).notes(profile.getNotes()).build();
    }

    public ApplicationResponse<Profile> updateById(Long id, ProfileDto request) {
        try {
            Optional optional = this.profileDao.findById(id);
            Profile profile = (Profile)optional.get();
            this.updateEntityFromRequest(profile, request);
            Profile model = this.profileDao.updateById(profile);
            return ApplicationResponse.success((String)"Profile id is update successfully", (Object)model);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by Profile id" + e.getMessage()));
        }
    }

    private void updateEntityFromRequest(Profile profile, ProfileDto request) {
        if (request.getCompanyname() != null) {
            profile.setCompanyname(request.getCompanyname());
        }
        if (request.getCompanylogo() != null) {
            profile.setCompanylogo(request.getCompanylogo());
        }
        if (request.getMobilenumber() != null) {
            profile.setMobilenumber(request.getMobilenumber());
        }
        if (request.getEmail() != null) {
            profile.setEmail(request.getEmail());
        }
        if (request.getWebsiteaddress() != null) {
            profile.setWebsiteaddress(request.getWebsiteaddress());
        }
        if (request.getGstnumber() != null) {
            profile.setGstnumber(request.getGstnumber());
        }
        if (request.getCinnumber() != null) {
            profile.setCinnumber(request.getCinnumber());
        }
        if (request.getPrimarycurrency() != null) {
            profile.setCurrency(request.getPrimarycurrency());
        }
        if (request.getSecondarycurrency() != null) {
            profile.setCurrency(request.getSecondarycurrency());
        }
        if (request.getAddress1() != null) {
            profile.setAddress1(request.getAddress1());
        }
        if (request.getAddress2() != null) {
            profile.setAddress2(request.getAddress2());
        }
        if (request.getCity() != null) {
            profile.setCity(request.getCity());
        }
        if (request.getState() != null) {
            profile.setState(request.getState());
        }
        if (request.getCountry() != null) {
            profile.setCountry(request.getCountry());
        }
        if (request.getPincode() != null) {
            profile.setPincode(request.getPincode());
        }
        if (request.getNotes() != null) {
            profile.setNotes(request.getNotes());
        }
        if (request.getCgst() != null) {
            profile.setCgst(request.getCgst());
        }
        if (request.getSgst() != null) {
            profile.setSgst(request.getSgst());
        }
    }

    public ApplicationResponse<Profile> deleteById(Long id) {
        try {
            this.profileDao.deleteById(id);
            return ApplicationResponse.success((String)"Profile id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Profile id" + e.getMessage()));
        }
    }

    @Generated
    public ProfileServiceImpl(ProfileValidation profileValidation) {
        this.profileValidation = profileValidation;
    }
}

