/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.companyProfile;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.companyProfile.Profile;
import com.enniyal.enniyal_project.companyProfile.ProfileDto;
import com.enniyal.enniyal_project.companyProfile.ProfileService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/profile"})
public class ProfileController {
    @Autowired
    private ProfileService ProfileService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Profile> createProfile(@RequestBody ProfileDto request) {
        try {
            return this.ProfileService.createProfile(request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create Profile" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Profile>> findAll() {
        try {
            return this.ProfileService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred find all Profile" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<ProfileDto> findById(@RequestParam Long id) {
        try {
            return this.ProfileService.findById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Profile id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Profile> updateById(@RequestParam Long id, @RequestBody ProfileDto request) {
        try {
            return this.ProfileService.updateById(id, request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by Profile id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Profile> deleteById(@RequestParam Long id) {
        try {
            return this.ProfileService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Profile id" + e.getMessage()));
        }
    }
}

