/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.client;

import com.enniyal.enniyal_project.client.ClientDto;
import com.enniyal.enniyal_project.exception.ValidationException;
import org.springframework.stereotype.Service;

@Service
public class ClientValidation {
    public void validationRequest(ClientDto clientDto) {
        if (clientDto == null) {
            throw new ValidationException("clientDto cannot be null");
        }
        if (clientDto.getContactperson() == null || clientDto.getContactperson().trim().isEmpty()) {
            throw new ValidationException("Contact person is required");
        }
        if (clientDto.getContactnumber() == null || !this.isValidMobile(clientDto.getContactnumber())) {
            throw new ValidationException("Invalid or missing contact number");
        }
        if (clientDto.getCompanyname() == null || clientDto.getCompanyname().trim().isEmpty()) {
            throw new ValidationException("Company name is required");
        }
        if (clientDto.getEmail() == null || !this.isValidEmail(clientDto.getEmail())) {
            throw new ValidationException("Invalid email address format");
        }
        if (clientDto.getAddress() == null || clientDto.getAddress().trim().isEmpty()) {
            throw new ValidationException("Address is required");
        }
    }

    private boolean isValidMobile(String mobile) {
        return mobile.matches("^[0-9]{10}$");
    }

    private boolean isValidEmail(String email) {
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }
}

