/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.client;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.client.Client;
import com.enniyal.enniyal_project.client.ClientDao;
import com.enniyal.enniyal_project.client.ClientDto;
import com.enniyal.enniyal_project.client.ClientService;
import com.enniyal.enniyal_project.client.ClientValidation;
import com.enniyal.enniyal_project.security.JwtService;
import com.enniyal.enniyal_project.user.Role;
import com.enniyal.enniyal_project.user.User;
import com.enniyal.enniyal_project.user.UserDao;
import com.enniyal.enniyal_project.user.UserRepository;
import com.enniyal.enniyal_project.utils.JavaSendApi;
import java.security.SecureRandom;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class ClientServiceImpl
implements ClientService {
    @Autowired
    private ClientDao clientDao;
    private final UserRepository userRepository;
    private final JwtService jwtService;
    private final ClientValidation clientValidation;
    private final UserDao userDao;
    private final JavaSendApi javaSendApi;

    public ApplicationResponse<Client> createClient(ClientDto request) {
        try {
            this.clientValidation.validationRequest(request);
            Optional optional = this.clientDao.findByEmail(request.getEmail());
            if (optional.isPresent()) {
                return ApplicationResponse.error((String)(request.getEmail() + "=This email id is already present"));
            }
            Optional clientOptional = this.clientDao.findByContactnumber(request.getContactnumber());
            if (clientOptional.isPresent()) {
                return ApplicationResponse.error((String)(request.getContactnumber() + "=This contact number is already present"));
            }
            Optional userEmail = this.userDao.findByEmail(request.getEmail());
            if (userEmail.isPresent()) {
                return ApplicationResponse.error((String)(request.getEmail() + "=This email id is already present in user table"));
            }
            Optional userMobile = this.userDao.findByMobile(Long.valueOf(Long.parseLong(request.getContactnumber())));
            if (userMobile.isPresent()) {
                return ApplicationResponse.error((String)(request.getContactnumber() + "=This contact number is already present in user table"));
            }
            Client client = this.mapRequestToEntity(request);
            Client model = this.clientDao.createClient(client);
            String rawPassword = this.generateRandomPassword(10);
            BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
            String hashedPassword = encoder.encode((CharSequence)rawPassword);
            User user = new User();
            user.setEmail(model.getEmail());
            user.setClientid(model.getId());
            user.setPassword(hashedPassword);
            user.setMobile(Long.valueOf(Long.parseLong(model.getContactnumber())));
            user.setFirstname(model.getContactperson());
            user.setRole(Role.CLIENT);
            user.setStatus(Boolean.valueOf(true));
            this.userRepository.save((Object)user);
            String To_mail = model.getEmail();
            String Subject = "Welcome to Joliass !";
            String body = "<html><body style='font-family: Arial, sans-serif; font-size: 14px; color: #333;'><p>Dear " + model.getName() + ",</p><p>Your account has been <strong>successfully created</strong>. Below are your login credentials:</p><table style='border-collapse: collapse; width: 100%; max-width: 400px;'>  <tr>    <td style='padding: 8px; border: 1px solid #ddd; background-color: #f4f4f4;'><strong>Login ID:</strong></td>    <td style='padding: 8px; border: 1px solid #ddd;'>" + model.getEmail() + "</td>  </tr>  <tr>    <td style='padding: 8px; border: 1px solid #ddd; background-color: #f4f4f4;'><strong>Password:</strong></td>    <td style='padding: 8px; border: 1px solid #ddd;'>" + rawPassword + "</td>  </tr></table><p><strong>Please keep this information secure</strong> and do not share it with anyone.</p><p>If you have any questions or need assistance, feel free to contact our support team.</p><p>Best regards,</p><p><strong>The Joliass Team</strong></p><p><a href='mailto:noreply@riotinfomedia.com'>noreply@riotinfomedia.com</a></p><p><a href='https://joliass.com' target='_blank'>joliass.com</a></p></body></html>";
            this.javaSendApi.sendMailWithAttachment(To_mail, body, Subject);
            return ApplicationResponse.success((String)"Client created successfully. Check email for login credentials.", (Object)model);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while saving client: " + e.getMessage()));
        }
    }

    private String generateRandomPassword(int length) {
        String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()-_";
        SecureRandom random = new SecureRandom();
        StringBuilder password = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            password.append(CHARACTERS.charAt(random.nextInt(CHARACTERS.length())));
        }
        return password.toString();
    }

    private Client mapRequestToEntity(ClientDto request) {
        return Client.builder().name(request.getName()).address(request.getAddress()).companyname(request.getCompanyname()).contactnumber(request.getContactnumber()).contactperson(request.getContactperson()).creditlimit(request.getCreditlimit()).creditperiod(request.getCreditperiod()).days(request.getDays()).email(request.getEmail()).gstno(request.getGstno()).type(request.getType()).unlimited(request.getUnlimited()).status(Boolean.valueOf(true)).build();
    }

    public ApplicationResponse<List<Client>> findAll() {
        try {
            List clients = this.clientDao.findAll();
            if (clients.isEmpty()) {
                return ApplicationResponse.error((String)"Client is not found");
            }
            return ApplicationResponse.success((String)"successfully find all client", (Object)clients);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all client" + e.getMessage()));
        }
    }

    public ApplicationResponse<ClientDto> findByClientId(Long id) {
        try {
            Optional optional = this.clientDao.findByClientId(id);
            if (optional.isPresent()) {
                ClientDto clientDto = this.mapEntityToDto((Client)optional.get());
                return ApplicationResponse.success((String)"successfully find client id", (Object)clientDto);
            }
            return ApplicationResponse.error((String)"client id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by client id" + e.getMessage()));
        }
    }

    private ClientDto mapEntityToDto(Client client) {
        return ClientDto.builder().id(client.getId()).name(client.getName()).address(client.getAddress()).companyname(client.getCompanyname()).contactnumber(client.getContactnumber()).contactperson(client.getContactperson()).creditlimit(client.getCreditlimit()).creditperiod(client.getCreditperiod()).days(client.getDays()).email(client.getEmail()).gstno(client.getGstno()).type(client.getType()).unlimited(client.getUnlimited()).status(Boolean.valueOf(true)).build();
    }

    public ApplicationResponse<Client> updateByClientId(Long id, ClientDto request) {
        try {
            Optional optional = this.clientDao.findByClientId(id);
            Client client = (Client)optional.get();
            this.updateEntityFromRequest(client, request);
            Client clientList = this.clientDao.updateByClientId(client);
            return ApplicationResponse.success((String)"update by client id", (Object)clientList);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by client id" + e.getMessage()));
        }
    }

    private void updateEntityFromRequest(Client client, ClientDto request) {
        if (request.getAddress() != null) {
            client.setAddress(request.getAddress());
        }
        if (request.getName() != null) {
            client.setName(request.getName());
        }
        if (request.getCompanyname() != null) {
            client.setCompanyname(request.getCompanyname());
        }
        if (request.getContactnumber() != null) {
            client.setContactnumber(request.getContactnumber());
        }
        if (request.getContactperson() != null) {
            client.setContactperson(request.getContactperson());
        }
        if (request.getCreditlimit() != null) {
            client.setCreditlimit(request.getCreditlimit());
        }
        if (request.getCreditperiod() != null) {
            client.setCreditperiod(request.getCreditperiod());
        }
        if (request.getDays() != null) {
            client.setDays(request.getDays());
        }
        if (request.getEmail() != null) {
            client.setEmail(request.getEmail());
        }
        if (request.getGstno() != null) {
            client.setGstno(request.getGstno());
        }
        if (request.getType() != null) {
            client.setType(request.getType());
        }
        if (request.getUnlimited() != null) {
            client.setUnlimited(request.getUnlimited());
        }
        if (request.getStatus() != null) {
            client.setStatus(Boolean.valueOf(true));
        }
    }

    public ApplicationResponse<Client> deleteById(Long id) {
        try {
            Optional optional = this.userRepository.findByClientid(id);
            User user = (User)optional.get();
            this.userDao.deleteByClientid(user.getId());
            this.clientDao.deleteById(id);
            return ApplicationResponse.success((String)"client id is deleted successfully", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by client id" + e.getMessage()));
        }
    }

    @Generated
    public ClientServiceImpl(UserRepository userRepository, JwtService jwtService, ClientValidation clientValidation, UserDao userDao, JavaSendApi javaSendApi) {
        this.userRepository = userRepository;
        this.jwtService = jwtService;
        this.clientValidation = clientValidation;
        this.userDao = userDao;
        this.javaSendApi = javaSendApi;
    }
}

