/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.client;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.client.Client;
import com.enniyal.enniyal_project.client.ClientDto;
import com.enniyal.enniyal_project.client.ClientService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/client"})
public class ClientController {
    @Autowired
    private ClientService clientService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Client> createClient(@RequestBody ClientDto request) {
        try {
            return this.clientService.createClient(request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create client" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Client>> findAll() {
        try {
            return this.clientService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all client" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<ClientDto> findByClientId(@RequestParam Long id) {
        try {
            return this.clientService.findByClientId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while fnid by client id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Client> updateByClientId(@RequestParam Long id, @RequestBody ClientDto request) {
        try {
            return this.clientService.updateByClientId(id, request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by client id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Client> deleteById(@RequestParam Long id) {
        try {
            return this.clientService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by client id" + e.getMessage()));
        }
    }
}

