/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.authentication;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.authentication.AuthenticationResponse;
import com.enniyal.enniyal_project.authentication.AuthenticationService;
import com.enniyal.enniyal_project.authentication.UserResponse;
import com.enniyal.enniyal_project.user.User;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/enniyal/sign"})
public class LoginAndRegistrationController {
    @Autowired
    private AuthenticationService authenticationService;

    @PutMapping(value={"/register"})
    public ApplicationResponse<AuthenticationResponse> register(@RequestBody UserResponse response) {
        return this.authenticationService.register(response);
    }

    @PutMapping(value={"/authenticate"})
    public ApplicationResponse<AuthenticationResponse> authenticate(@RequestBody UserResponse response) {
        return this.authenticationService.authenticate(response);
    }

    @PostMapping(value={"/getuserdetails"})
    public ApplicationResponse<UserResponse> getDetails(@RequestHeader(value="Authorization") String AS) {
        return this.authenticationService.getDetails(AS);
    }

    @PostMapping(value={"/checkemail"})
    public ApplicationResponse<Optional<User>> checkEmail(@RequestParam String email) {
        return this.authenticationService.checkEmail(email);
    }

    @PostMapping(value={"/checkmobile"})
    public ApplicationResponse<Optional<User>> checkMobile(@RequestParam Long mobile) {
        return this.authenticationService.checkMobile(mobile);
    }
}

