/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.authentication;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.authentication.AuthenticationResponse;
import com.enniyal.enniyal_project.authentication.AuthenticationService;
import com.enniyal.enniyal_project.authentication.UserResponse;
import com.enniyal.enniyal_project.password.PasswordDto;
import com.enniyal.enniyal_project.security.JwtService;
import com.enniyal.enniyal_project.user.EnniyalUserValidation;
import com.enniyal.enniyal_project.user.Role;
import com.enniyal.enniyal_project.user.User;
import com.enniyal.enniyal_project.user.UserDao;
import com.enniyal.enniyal_project.user.UserValidation;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.json.JSONObject;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    private final JwtService jwtService;
    private final PasswordEncoder encoder;
    private final AuthenticationManager authenticationManager;
    private final UserDao userDao;
    private final EnniyalUserValidation enniyalUserValidation;
    private final UserValidation userValidation;

    public ApplicationResponse<AuthenticationResponse> register(UserResponse response) {
        this.userValidation.validationRequest(response);
        Optional optional = this.userDao.findByEmail(response.getEmail());
        if (optional.isPresent()) {
            return ApplicationResponse.error((String)"This email id is already present");
        }
        Optional mobile = this.userDao.findByMobile(response.getMobile());
        if (mobile.isPresent()) {
            return ApplicationResponse.error((String)"This mobile number is already present");
        }
        this.enniyalUserValidation.validateRequest(response);
        User user = User.builder().firstname(response.getFirstname()).email(response.getEmail()).mobile(response.getMobile()).role(Role.ADMIN).password(this.encoder.encode((CharSequence)response.getPassword())).status(Boolean.valueOf(true)).loginid(response.getLoginid()).build();
        this.userDao.save(user);
        String jwtToken = this.jwtService.generateToken((UserDetails)user);
        AuthenticationResponse authResponse = AuthenticationResponse.builder().token(jwtToken).build();
        return ApplicationResponse.success((String)"User registered successfully", (Object)authResponse);
    }

    public ApplicationResponse<AuthenticationResponse> authenticate(UserResponse response) {
        try {
            User user = null;
            if (response.getEmail() != null && !response.getEmail().isEmpty()) {
                if (response.getEmail().contains("@") || response.getEmail().contains("admin")) {
                    user = (User)this.userDao.findByEmail(response.getEmail()).orElseThrow(() -> new UsernameNotFoundException("User not found with email: " + response.getEmail()));
                } else {
                    user = (User)this.userDao.findByLoginCode(response.getEmail()).orElseThrow(null);
                    if (user == null) {
                        return ApplicationResponse.error((String)("User not found with empcode: " + response.getEmail()));
                    }
                    if (user.getEmail() == null || user.getEmail().isEmpty()) {
                        return ApplicationResponse.error((String)"User found with empcode but no email available for authentication.");
                    }
                }
                this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)user.getEmail(), (Object)response.getPassword()));
                String jwtToken = this.jwtService.generateToken((UserDetails)user);
                AuthenticationResponse authResponse = AuthenticationResponse.builder().token(jwtToken).build();
                return ApplicationResponse.success((String)"Authentication successful", (Object)authResponse);
            }
            return ApplicationResponse.error((String)"Invalid login request: no identifier provided");
        }
        catch (UsernameNotFoundException ex) {
            return ApplicationResponse.error((String)("Authentication failed: " + ex.getMessage()));
        }
        catch (BadCredentialsException ex) {
            return ApplicationResponse.error((String)"Authentication failed: invalid credentials");
        }
        catch (IllegalStateException ex) {
            return ApplicationResponse.error((String)("Authentication failed: " + ex.getMessage()));
        }
        catch (Exception ex) {
            return ApplicationResponse.error((String)("An unexpected error occurred during authentication: " + ex.getMessage()));
        }
    }

    public ApplicationResponse<UserResponse> getDetails(String aS) {
        try {
            String bearer = aS.substring(aS.indexOf(".") + 1);
            String bearers = bearer.substring(0, bearer.indexOf("."));
            Base64.Decoder decoder = Base64.getUrlDecoder();
            String token = new String(decoder.decode(bearers));
            JSONObject jsonObject = new JSONObject(token);
            String userName = jsonObject.getString("sub");
            Optional creator = this.userDao.findByEmail(userName);
            if (creator.isPresent()) {
                User user = (User)creator.get();
                UserResponse res = new UserResponse();
                res.setId(user.getId());
                res.setLoginid(user.getLoginid());
                res.setEmail(user.getEmail());
                res.setFirstname(user.getFirstname());
                res.setMobile(user.getMobile());
                res.setRole(user.getRole());
                return ApplicationResponse.success((String)"User details retrieved successfully", (Object)res);
            }
            return ApplicationResponse.error((String)"Error: User not found.");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("Error processing request: " + e.getMessage()));
        }
    }

    public ApplicationResponse<Optional<User>> checkEmail(String email) {
        try {
            Optional optional = this.userDao.findByEmail(email);
            if (optional.isPresent()) {
                return ApplicationResponse.error((String)"This Email id is already present");
            }
            return ApplicationResponse.success((String)"This Email id is available", (Object)optional);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)"Error: Email not found");
        }
    }

    public ApplicationResponse<Optional<User>> checkMobile(Long mobile) {
        try {
            System.out.println("1");
            Optional optional = this.userDao.findByMobile(mobile);
            System.out.println("12");
            if (optional.isPresent()) {
                System.out.println("13");
                return ApplicationResponse.error((String)"This mobile number already present");
            }
            System.out.println("14");
            return ApplicationResponse.success((String)"This mobile number is available", (Object)optional);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)"Error: mobile number not found");
        }
    }

    public PasswordDto getPassDetails(String as) {
        String bearer = as.substring(as.indexOf(".") + 1);
        String bearers = bearer.substring(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearers));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEmail(userName);
        if (creator.isPresent()) {
            PasswordDto res = new PasswordDto();
            User user = (User)creator.get();
            res.setOldPassword(user.getPassword());
            return res;
        }
        throw new RuntimeException("Error: User not found");
    }

    @Generated
    public AuthenticationServiceImpl(JwtService jwtService, PasswordEncoder encoder, AuthenticationManager authenticationManager, UserDao userDao, EnniyalUserValidation enniyalUserValidation, UserValidation userValidation) {
        this.jwtService = jwtService;
        this.encoder = encoder;
        this.authenticationManager = authenticationManager;
        this.userDao = userDao;
        this.enniyalUserValidation = enniyalUserValidation;
        this.userValidation = userValidation;
    }
}

