/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.attendance;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.attendaceDetails.AttendanceDetails;
import com.enniyal.enniyal_project.attendaceDetails.AttendanceDetailsDao;
import com.enniyal.enniyal_project.attendaceDetails.AttendanceDetailsRepository;
import com.enniyal.enniyal_project.attendance.Attendance;
import com.enniyal.enniyal_project.attendance.AttendanceDao;
import com.enniyal.enniyal_project.attendance.AttendanceDto;
import com.enniyal.enniyal_project.attendance.AttendanceService;
import com.enniyal.enniyal_project.attendance.AttendanceValidation;
import com.enniyal.enniyal_project.attendance.Status;
import com.enniyal.enniyal_project.employee.EmployeeRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AttendanceServiceImpl
implements AttendanceService {
    private final AttendanceDao attendanceDao;
    private final AttendanceDetailsDao attendanceDetailsDao;
    private final AttendanceValidation attendanceValidation;
    private final EmployeeRepository employeeRepository;
    private final AttendanceDetailsRepository attendanceDetailsRepository;

    public ApplicationResponse<Attendance> createAttendance(AttendanceDto attendanceDto) {
        try {
            AttendanceDetails attendanceDetails;
            this.attendanceValidation.validationRequest(attendanceDto);
            Attendance attendance = this.mapRequestToEntity(attendanceDto);
            Optional optional = this.attendanceDetailsDao.findByEmpidAndMonthAndYear(attendance.getEmpid(), attendance.getCurrentmonth(), attendance.getCurrentyear());
            if (optional.isPresent()) {
                attendanceDetails = (AttendanceDetails)optional.get();
                long totalPresent = Long.parseLong(attendanceDetails.getTotalperesent());
                long totalAbsent = Long.parseLong(attendanceDetails.getTotalabsent());
                long noOfHolidays = Long.parseLong(attendanceDetails.getNoofholidays());
                long lop = Long.parseLong(attendanceDetails.getLop());
                long paidLeave = Long.parseLong(attendanceDetails.getPaidleave());
                if (attendance.getStatus() == Status.PRESENT) {
                    ++totalPresent;
                } else if (attendance.getStatus() == Status.ABSENT) {
                    ++totalAbsent;
                } else if (attendance.getStatus() == Status.HOLIDAY) {
                    ++noOfHolidays;
                } else if (attendance.getStatus() == Status.LOP) {
                    ++lop;
                } else if (attendance.getStatus() == Status.PAIDLEAVE) {
                    ++paidLeave;
                }
                attendanceDetails.setTotalperesent(String.valueOf(totalPresent));
                attendanceDetails.setTotalabsent(String.valueOf(totalAbsent));
                attendanceDetails.setNoofholidays(String.valueOf(noOfHolidays));
                attendanceDetails.setLop(String.valueOf(lop));
                attendanceDetails.setPaidleave(String.valueOf(paidLeave));
            } else {
                Long totalPresent = 0L;
                Long totalAbsent = 0L;
                Long noOfHolidays = 0L;
                Long lop = 0L;
                Long paidLeave = 0L;
                if (attendance.getStatus() == Status.PRESENT) {
                    Long l = totalPresent;
                    totalPresent = totalPresent + 1L;
                } else if (attendance.getStatus() == Status.ABSENT) {
                    Long l = totalAbsent;
                    totalAbsent = totalAbsent + 1L;
                } else if (attendance.getStatus() == Status.HOLIDAY) {
                    Long l = noOfHolidays;
                    noOfHolidays = noOfHolidays + 1L;
                } else if (attendance.getStatus() == Status.LOP) {
                    Long l = lop;
                    lop = lop + 1L;
                } else if (attendance.getStatus() == Status.PAIDLEAVE) {
                    Long l = paidLeave;
                    paidLeave = paidLeave + 1L;
                }
                attendanceDetails = new AttendanceDetails();
                attendanceDetails.setEmpid(attendance.getEmpid());
                attendanceDetails.setMonth(attendance.getCurrentmonth());
                attendanceDetails.setYear(attendance.getCurrentyear());
                attendanceDetails.setTotalperesent(totalPresent.toString());
                attendanceDetails.setTotalabsent(totalAbsent.toString());
                attendanceDetails.setNoofholidays(noOfHolidays.toString());
                attendanceDetails.setLop(lop.toString());
                attendanceDetails.setPaidleave(paidLeave.toString());
            }
            this.attendanceDetailsDao.save(attendanceDetails);
            Optional checkOptional = this.employeeRepository.findById((Object)attendanceDto.getEmpid());
            if (checkOptional.isEmpty()) {
                return ApplicationResponse.error((String)"This employee id is not found");
            }
            Attendance savedAttendance = this.attendanceDao.createAttendance(attendance);
            return ApplicationResponse.success((String)"Attendance is create successfully", (Object)savedAttendance);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while save attendance" + e.getMessage()));
        }
    }

    private Attendance mapRequestToEntity(AttendanceDto attendanceDto) {
        return Attendance.builder().empid(attendanceDto.getEmpid()).currentdate(attendanceDto.getCurrentdate()).currentmonth(attendanceDto.getCurrentmonth()).currentyear(attendanceDto.getCurrentyear()).currenttime(attendanceDto.getCurrenttime()).status(attendanceDto.getStatus()).reason(attendanceDto.getReason()).build();
    }

    public ApplicationResponse<List<Attendance>> findAll() {
        try {
            List attendances = this.attendanceDao.findAll();
            if (attendances.isEmpty()) {
                return ApplicationResponse.error((String)"attendance not found");
            }
            return ApplicationResponse.success((String)"successfully find all record", (Object)attendances);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all attendance" + e.getMessage()));
        }
    }

    public ApplicationResponse<?> findById(Long id) {
        try {
            Optional optional = this.attendanceDao.findById(id);
            if (optional.isPresent()) {
                AttendanceDto saveDto = this.mapToEntityDto((Attendance)optional.get());
                return ApplicationResponse.success((String)"successfully find by id", (Object)saveDto);
            }
            return ApplicationResponse.error((String)"attendance id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by attendance id" + e.getMessage()));
        }
    }

    private AttendanceDto mapToEntityDto(Attendance attendance) {
        return AttendanceDto.builder().id(attendance.getId()).empid(attendance.getEmpid()).currentdate(attendance.getCurrentdate()).currentmonth(attendance.getCurrentmonth()).currenttime(attendance.getCurrenttime()).currentyear(attendance.getCurrentyear()).status(attendance.getStatus()).reason(attendance.getReason()).build();
    }

    public ApplicationResponse<Attendance> updateById(AttendanceDto attendanceDto, Long id) {
        try {
            Optional optional = this.attendanceDao.findById(id);
            Attendance attendance = (Attendance)optional.get();
            this.updateEntityFromReqest(attendance, attendanceDto);
            Attendance saveAttendance = this.attendanceDao.updateById(attendance);
            return ApplicationResponse.success((String)"update successfully", (Object)saveAttendance);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by attendance id" + e.getMessage()));
        }
    }

    private void updateEntityFromReqest(Attendance attendance, AttendanceDto attendanceDto) {
        if (attendanceDto.getCurrentdate() != null) {
            attendance.setCurrentdate(attendanceDto.getCurrentdate());
        }
        if (attendanceDto.getCurrentmonth() != null) {
            attendance.setCurrentmonth(attendanceDto.getCurrentmonth());
        }
        if (attendanceDto.getCurrenttime() != null) {
            attendance.setCurrenttime(attendanceDto.getCurrenttime());
        }
        if (attendanceDto.getCurrentyear() != null) {
            attendance.setCurrentyear(attendanceDto.getCurrentyear());
        }
        if (attendanceDto.getEmpid() != null) {
            attendance.setEmpid(attendanceDto.getEmpid());
        }
        if (attendanceDto.getStatus() != null) {
            attendance.setStatus(attendanceDto.getStatus());
        }
        if (attendanceDto.getReason() != null) {
            attendance.setReason(attendanceDto.getReason());
        }
    }

    public ApplicationResponse<Attendance> deleteById(Long id) {
        try {
            this.attendanceDao.deleteById(id);
            return ApplicationResponse.success((String)("Attendance ID " + id + " and related details deleted successfully"), null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while deleting attendance: " + e.getMessage()));
        }
    }

    @Generated
    public AttendanceServiceImpl(AttendanceDao attendanceDao, AttendanceDetailsDao attendanceDetailsDao, AttendanceValidation attendanceValidation, EmployeeRepository employeeRepository, AttendanceDetailsRepository attendanceDetailsRepository) {
        this.attendanceDao = attendanceDao;
        this.attendanceDetailsDao = attendanceDetailsDao;
        this.attendanceValidation = attendanceValidation;
        this.employeeRepository = employeeRepository;
        this.attendanceDetailsRepository = attendanceDetailsRepository;
    }
}

