/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.attendance;

import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import com.enniyal.enniyal_project.attendance.Attendance;
import com.enniyal.enniyal_project.attendance.AttendanceDto;
import com.enniyal.enniyal_project.attendance.AttendanceService;
import java.util.List;
import lombok.Generated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/attendance"})
public class AttendanceController {
    private final AttendanceService attendanceService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Attendance> createAttendance(@RequestBody AttendanceDto attendanceDto) {
        try {
            return this.attendanceService.createAttendance(attendanceDto);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create attendance" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Attendance>> findAll() {
        try {
            return this.attendanceService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all attendance" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<?> findById(@RequestParam Long id) {
        try {
            return this.attendanceService.findById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by attendance id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Attendance> updateById(@RequestBody AttendanceDto attendanceDto, @RequestParam Long id) {
        try {
            return this.attendanceService.updateById(attendanceDto, id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update attendance" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Attendance> deleteById(@RequestParam Long id) {
        try {
            return this.attendanceService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by attendance id" + e.getMessage()));
        }
    }

    @Generated
    public AttendanceController(AttendanceService attendanceService) {
        this.attendanceService = attendanceService;
    }
}

