/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.account;

import com.enniyal.enniyal_project.account.AccountDto;
import com.enniyal.enniyal_project.exception.ValidationException;
import org.springframework.stereotype.Service;

@Service
public class AccountValidation {
    public void validationRequest(AccountDto accountDto) {
        if (accountDto == null) {
            throw new ValidationException(" accountDto cannot be null");
        }
        if (accountDto.getName() == null || accountDto.getName().isEmpty()) {
            throw new ValidationException("name is required");
        }
        if (accountDto.getCompanyname() == null || accountDto.getCompanyname().trim().isEmpty()) {
            throw new ValidationException("Company name is required");
        }
        if (accountDto.getContactnumber() == null || !this.isValidMobile(accountDto.getContactnumber())) {
            throw new ValidationException("Invalid or missing contact number");
        }
        if (accountDto.getEmail() == null || !this.isValidEmail(accountDto.getEmail())) {
            throw new ValidationException("Invalid email address format");
        }
        if (accountDto.getNewpassword() == null || accountDto.getNewpassword().trim().isEmpty()) {
            throw new ValidationException("New password is required");
        }
        if (accountDto.getConfirmpassword() == null || accountDto.getConfirmpassword().trim().isEmpty()) {
            throw new ValidationException("Confirm password is required");
        }
        if (!accountDto.getNewpassword().equals(accountDto.getConfirmpassword())) {
            throw new ValidationException("Passwords do not match");
        }
    }

    private boolean isValidMobile(String mobile) {
        return mobile.matches("^[0-9]{10}$");
    }

    private boolean isValidEmail(String email) {
        String emailRegex = "^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$";
        return email.matches(emailRegex);
    }
}

