/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.account;

import com.enniyal.enniyal_project.account.Account;
import com.enniyal.enniyal_project.account.AccountDao;
import com.enniyal.enniyal_project.account.AccountDto;
import com.enniyal.enniyal_project.account.AccountService;
import com.enniyal.enniyal_project.account.AccountValidation;
import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceImpl
implements AccountService {
    @Autowired
    private AccountDao accountDao;
    private final PasswordEncoder encoder;
    private final AccountValidation accountValidation;

    public ApplicationResponse<Account> createAccount(AccountDto request) {
        try {
            this.accountValidation.validationRequest(request);
            Optional optional = this.accountDao.findByEmail(request.getEmail());
            if (optional.isPresent()) {
                return ApplicationResponse.error((String)(request.getEmail() + "=This email id is already present"));
            }
            Account account = this.mapRequestToEntity(request);
            if (request.getUpload() == null) {
                account.setUpload("https://storage.megashop.my/FindClub/16112024213328714.jpeg");
            }
            if (!request.getNewpassword().equals(request.getConfirmpassword())) {
                return ApplicationResponse.error((String)"Newpassword and confirm password do not match");
            }
            Account accounts = this.accountDao.createAccount(account);
            return ApplicationResponse.success((String)"Account create successfully", (Object)accounts);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create account" + e.getMessage()));
        }
    }

    private Account mapRequestToEntity(AccountDto request) {
        return Account.builder().companyname(request.getCompanyname()).contactnumber(request.getContactnumber()).email(request.getEmail()).name(request.getName()).newpassword(this.encoder.encode((CharSequence)request.getNewpassword())).confirmpassword(this.encoder.encode((CharSequence)request.getConfirmpassword())).upload(request.getUpload()).build();
    }

    public ApplicationResponse<List<Account>> findAll() {
        try {
            List accounts = this.accountDao.findAll();
            return ApplicationResponse.success((String)" find all Account", (Object)accounts);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all account" + e.getMessage()));
        }
    }

    public ApplicationResponse<AccountDto> findByAccountId(Long id) {
        try {
            Optional optional = this.accountDao.findByAccountId(id);
            if (optional.isPresent()) {
                AccountDto accountDto = this.mapEntityToDto((Account)optional.get());
                return ApplicationResponse.success((String)"Successfully find by account id", (Object)accountDto);
            }
            return ApplicationResponse.error((String)"Account id is not found");
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by account id" + e.getMessage()));
        }
    }

    private AccountDto mapEntityToDto(Account account) {
        return AccountDto.builder().id(account.getId()).companyname(account.getCompanyname()).contactnumber(account.getContactnumber()).email(account.getEmail()).name(account.getName()).newpassword(account.getNewpassword()).confirmpassword(account.getConfirmpassword()).upload(account.getUpload()).build();
    }

    public ApplicationResponse<Account> updateByAccountId(Long id, AccountDto request) {
        try {
            Optional optional = this.accountDao.findByAccountId(id);
            Account account = (Account)optional.get();
            this.updateEntityFromRequest(account, request);
            Account accounts = this.accountDao.updateByAccountId(account);
            return ApplicationResponse.success((String)"Successfully update by account id", (Object)accounts);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by account id" + e.getMessage()));
        }
    }

    private void updateEntityFromRequest(Account account, AccountDto request) {
        if (request.getCompanyname() != null) {
            account.setCompanyname(request.getCompanyname());
        }
        if (request.getContactnumber() != null) {
            account.setContactnumber(request.getContactnumber());
        }
        if (request.getName() != null) {
            account.setName(request.getName());
        }
        if (request.getEmail() != null) {
            account.setEmail(request.getEmail());
        }
        if (request.getNewpassword() != null) {
            account.setNewpassword(request.getNewpassword());
        }
        if (request.getConfirmpassword() != null) {
            account.setConfirmpassword(request.getConfirmpassword());
        }
        if (request.getUpload() != null) {
            account.setUpload(request.getUpload());
        }
    }

    public ApplicationResponse<Account> deleteById(Long id) {
        try {
            this.accountDao.deleteById(id);
            return ApplicationResponse.success((String)"Successfully delete by account id", null);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by account id" + e.getMessage()));
        }
    }

    @Generated
    public AccountServiceImpl(PasswordEncoder encoder, AccountValidation accountValidation) {
        this.encoder = encoder;
        this.accountValidation = accountValidation;
    }
}

