/*
 * Decompiled with CFR 0.152.
 */
package com.enniyal.enniyal_project.account;

import com.enniyal.enniyal_project.account.Account;
import com.enniyal.enniyal_project.account.AccountDto;
import com.enniyal.enniyal_project.account.AccountService;
import com.enniyal.enniyal_project.applicationResponse.ApplicationResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/account"})
public class AccountController {
    @Autowired
    private AccountService accountService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Account> createAccount(@RequestBody AccountDto request) {
        try {
            return this.accountService.createAccount(request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create account" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Account>> findAll() {
        try {
            return this.accountService.findAll();
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred find all Account" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<AccountDto> findByAccountId(@RequestParam Long id) {
        try {
            return this.accountService.findByAccountId(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by Account id" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Account> updateByAccountId(@RequestParam Long id, @RequestBody AccountDto request) {
        try {
            return this.accountService.updateByAccountId(id, request);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by Account id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Account> deleteById(@RequestParam Long id) {
        try {
            return this.accountService.deleteById(id);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by Account id" + e.getMessage()));
        }
    }
}

