/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.transportRegister;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.transportRegister.Transport;
import com.rugaa.NambaSchool.transportRegister.TransportDao;
import com.rugaa.NambaSchool.transportRegister.TransportDto;
import com.rugaa.NambaSchool.transportRegister.TransportService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransportServiceImpl
implements TransportService {
    @Autowired
    private TransportDao transportDao;

    public Transport createTransport(TransportDto dto) {
        try {
            Transport transport = new Transport();
            if (dto.getVehicleNumber() != null) {
                transport.setVehicleNumber(dto.getVehicleNumber());
            }
            if (dto.getVehicleType() != null) {
                transport.setVehicleType(dto.getVehicleType());
            }
            if (dto.getDriverName() != null) {
                transport.setDriverName(dto.getDriverName());
            }
            if (dto.getDriverAddress() != null) {
                transport.setDriverAddress(dto.getDriverAddress());
            }
            if (dto.getDriverMobile() != null) {
                transport.setDriverMobile(dto.getDriverMobile());
            }
            if (dto.getEmergencyContact() != null) {
                transport.setEmergencyContact(dto.getEmergencyContact());
            }
            if (dto.getBusRoute() != null) {
                transport.setBusRoute(dto.getBusRoute());
            }
            if (dto.getRouteType() != null) {
                transport.setRouteType(dto.getRouteType());
            }
            if (dto.getGPSTracking() != null) {
                transport.setGPSTracking(dto.getGPSTracking());
            }
            if (dto.getStudent() != null) {
                transport.setStudent(dto.getStudent());
            }
            if (dto.getStaff() != null) {
                transport.setStaff(dto.getStaff());
            }
            if (dto.getPickupLocation() != null) {
                transport.setPickupLocation(dto.getPickupLocation());
            }
            if (dto.getDropLocation() != null) {
                transport.setDropLocation(dto.getDropLocation());
            }
            return this.transportDao.saveTransport(transport);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while save transport" + e.getMessage());
        }
    }

    public List<Transport> getAllTransport() {
        try {
            List list = this.transportDao.getAllTransport();
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while get all transport" + e.getMessage());
        }
    }

    public ApplicationResponse<Optional<Transport>> findByTransportId(Long id) {
        try {
            Optional optional = this.transportDao.findByTransportId(id);
            if (optional.isEmpty()) {
                return new ApplicationResponse("Error", "transport not found", Optional.empty());
            }
            return new ApplicationResponse("Success", "transport found successfully", (Object)optional);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find by transport id" + e.getMessage());
        }
    }

    public ApplicationResponse<Transport> deleteByTransportId(Long id) {
        try {
            this.transportDao.deleteByTransportId(id);
            return new ApplicationResponse("Success", "transport id is deleted successfully", null);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find by transport id" + e.getMessage());
        }
    }

    public Transport updateByTransportId(TransportDto dto, Long id) {
        try {
            Optional optional = this.transportDao.findByTransportId(id);
            Transport transport = (Transport)optional.get();
            if (dto.getVehicleNumber() != null) {
                transport.setVehicleNumber(dto.getVehicleNumber());
            }
            if (dto.getVehicleType() != null) {
                transport.setVehicleType(dto.getVehicleType());
            }
            if (dto.getDriverName() != null) {
                transport.setDriverName(dto.getDriverName());
            }
            if (dto.getDriverAddress() != null) {
                transport.setDriverAddress(dto.getDriverAddress());
            }
            if (dto.getDriverMobile() != null) {
                transport.setDriverMobile(dto.getDriverMobile());
            }
            if (dto.getEmergencyContact() != null) {
                transport.setEmergencyContact(dto.getEmergencyContact());
            }
            if (dto.getBusRoute() != null) {
                transport.setBusRoute(dto.getBusRoute());
            }
            if (dto.getRouteType() != null) {
                transport.setRouteType(dto.getRouteType());
            }
            if (dto.getGPSTracking() != null) {
                transport.setGPSTracking(dto.getGPSTracking());
            }
            if (dto.getStudent() != null) {
                transport.setStudent(dto.getStudent());
            }
            if (dto.getStaff() != null) {
                transport.setStaff(dto.getStaff());
            }
            if (dto.getPickupLocation() != null) {
                transport.setPickupLocation(dto.getPickupLocation());
            }
            if (dto.getDropLocation() != null) {
                transport.setDropLocation(dto.getDropLocation());
            }
            return this.transportDao.updateByTransportId(transport);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while update by transport id" + e.getMessage());
        }
    }
}

