/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.transportRegister;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.transportRegister.Transport;
import com.rugaa.NambaSchool.transportRegister.TransportDto;
import com.rugaa.NambaSchool.transportRegister.TransportService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/transport"})
public class TransportController {
    @Autowired
    private TransportService transportService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Transport> createTransport(@RequestBody TransportDto dto) {
        try {
            Transport transport = this.transportService.createTransport(dto);
            return new ApplicationResponse("Success", "transport create successfully", (Object)transport);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while create transport", null);
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Transport>> getAllTransport() {
        try {
            List list = this.transportService.getAllTransport();
            return new ApplicationResponse(null, null, (Object)list);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while get all transport", null);
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<Optional<Transport>> findByTransportId(@RequestParam Long id) {
        try {
            return this.transportService.findByTransportId(id);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while find by transport id", null);
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Transport> deleteByTransportId(@RequestParam Long id) {
        try {
            return this.transportService.deleteByTransportId(id);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while delete by transport id", null);
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Transport> updateByTransportId(@RequestBody TransportDto dto, @RequestParam Long id) {
        try {
            Transport transport = this.transportService.updateByTransportId(dto, id);
            return new ApplicationResponse(null, null, (Object)transport);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while update by transport id", null);
        }
    }
}

