/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.teacherRegister;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.teacherRegister.TeacherDto;
import com.rugaa.NambaSchool.teacherRegister.TeacherModel;
import com.rugaa.NambaSchool.teacherRegister.TeacherService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/teacher"})
public class TeacherController {
    @Autowired
    private TeacherService teacherService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<TeacherModel> saveteacher(@RequestBody TeacherDto request) {
        try {
            TeacherModel model = this.teacherService.saveteacher(request);
            return new ApplicationResponse("Success", "Student create success fully", (Object)model);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while save teacher", null);
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<TeacherModel>> getAll() {
        try {
            List list = this.teacherService.getAll();
            return new ApplicationResponse(null, null, (Object)list);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while get all teacher", null);
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<Optional<TeacherModel>> findByTeacherId(@RequestParam Long teacherId) {
        try {
            return this.teacherService.findByTeacherId(teacherId);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while find by teacher id", null);
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<TeacherModel> deleteByTeacherId(@RequestParam Long teacherId) {
        try {
            return this.teacherService.deleteByTeacherId(teacherId);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while delete by teacher id", null);
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<TeacherModel> updateTeacherById(@RequestBody TeacherDto request, @RequestParam Long teacherId) {
        try {
            TeacherModel model = this.teacherService.updateTeacherById(request, teacherId);
            return new ApplicationResponse("Success", "Student create success fully", (Object)model);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while save teacher", null);
        }
    }
}

