/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.studentRegister;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.studentRegister.Student;
import com.rugaa.NambaSchool.studentRegister.StudentDto;
import com.rugaa.NambaSchool.studentRegister.StudentService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/student"})
public class StudentController {
    @Autowired
    private StudentService studentService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Student> saveStudent(@RequestBody StudentDto dto) {
        try {
            Student student = this.studentService.saveStudent(dto);
            return new ApplicationResponse("Success", "Student create success fully", (Object)student);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while save student", null);
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<Student>> getAllStudent() {
        try {
            List list = this.studentService.getAllStudent();
            return new ApplicationResponse(null, null, (Object)list);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while get all student", null);
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<Optional<Student>> findByStudentId(@RequestParam Long id) {
        try {
            return this.studentService.findByStudentId(id);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while find by student id", null);
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<Student> deleteByStudentId(@RequestParam Long id) {
        try {
            return this.studentService.deleteByStudentId(id);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while delete by student id", null);
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Student> updateByStudentId(@RequestBody StudentDto dto, @RequestParam Long id) {
        try {
            Student student = this.studentService.updateByStudentId(dto, id);
            return new ApplicationResponse("Success", null, (Object)student);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while update student", null);
        }
    }
}

