/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolregistration;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.authentication.AuthenticationResponse;
import com.rugaa.NambaSchool.authentication.AuthenticationService;
import com.rugaa.NambaSchool.authentication.UserResponse;
import com.rugaa.NambaSchool.dbCreator.SchoolDatabaseCreator;
import com.rugaa.NambaSchool.email.EmailSender;
import com.rugaa.NambaSchool.exception.ValidationException;
import com.rugaa.NambaSchool.schoolregistration.RandomCodeGenerator;
import com.rugaa.NambaSchool.schoolregistration.SchoolLoginRequest;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistration;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistrationDto;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistrationMapper;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistrationRepository;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistrationService;
import com.rugaa.NambaSchool.schoolregistration.SchoolRegistrationValidation;
import com.rugaa.NambaSchool.security.JwtService;
import com.rugaa.NambaSchool.user.Role;
import com.rugaa.NambaSchool.user.User;
import com.rugaa.NambaSchool.user.UserDao;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchoolRegistrationServiceImpl
implements SchoolRegistrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchoolRegistrationServiceImpl.class);
    private final SchoolRegistrationRepository schoolRegistrationRepository;
    private final PasswordEncoder encoder;
    private final UserDao userDao;
    private final JwtService jwtService;
    private final AuthenticationService authenticationService;
    private final SchoolRegistrationValidation registrationValidation;
    private final EmailSender javaSendApi;
    private final SchoolRegistrationMapper schoolRegistrationMapper;

    public ApplicationResponse<AuthenticationResponse> register(SchoolLoginRequest request) {
        try {
            log.info("Starting registration for school: {}", (Object)request.getSchoolName());
            User user = this.createNewUser(request);
            user.setLoginid(RandomCodeGenerator.generateLoginID());
            User saveduser = this.userDao.save(user);
            this.javaSendApi.sendRegistrationEmail(saveduser.getEmail(), saveduser.getFirstname(), saveduser.getLoginid(), request.getPassword());
            String jwtToken = this.jwtService.generateToken((UserDetails)user);
            log.info("User registered successfully with email: {}", (Object)request.getEmail());
            return ApplicationResponse.success((String)"User registered successfully", (Object)new AuthenticationResponse(jwtToken));
        }
        catch (Exception e) {
            log.error("Registration failed for school {}: {}", new Object[]{request.getSchoolName(), e.getMessage(), e});
            return ApplicationResponse.error((String)("Registration failed: " + e.getMessage()));
        }
    }

    @Transactional
    public ApplicationResponse<SchoolRegistration> createSchool(SchoolRegistrationDto request, String token) {
        try {
            log.info("Creating school with name: {}", (Object)request.getSchoolName());
            UserResponse loggerdetails = this.authenticationService.getTokenDetails(token);
            if (loggerdetails == null || loggerdetails.getId() == null) {
                throw new ValidationException("Invalid token or user details not found.");
            }
            this.registrationValidation.validateRequest(request);
            SchoolRegistration school = this.schoolRegistrationMapper.mapRequestToEntity(request);
            school.setApprovalStatus(Boolean.valueOf(false));
            school.setUserid(loggerdetails.getId());
            SchoolRegistration savedSchool = (SchoolRegistration)this.schoolRegistrationRepository.save((Object)school);
            log.info("School registration created successfully for school: {}", (Object)savedSchool.getSchoolName());
            return ApplicationResponse.success((String)"School registration created successfully.", (Object)savedSchool);
        }
        catch (ValidationException | DataIntegrityViolationException e) {
            log.error("Error during school creation: {}", (Object)e.getMessage(), (Object)e);
            return ApplicationResponse.error((String)e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected error during school creation: {}", (Object)e.getMessage(), (Object)e);
            return ApplicationResponse.error((String)("Error creating school registration: " + e.getMessage()));
        }
    }

    public ApplicationResponse<SchoolRegistrationDto> getSchoolById(Long id, String token) {
        try {
            log.info("Fetching school with ID: {}", (Object)id);
            if (id == null || id <= 0L) {
                throw new ValidationException("Invalid school ID.");
            }
            Optional schoolOpt = this.schoolRegistrationRepository.findById((Object)id);
            if (schoolOpt.isPresent()) {
                SchoolRegistrationDto schoolDto = this.schoolRegistrationMapper.mapEntityToDto((SchoolRegistration)schoolOpt.get());
                log.info("School found with ID: {}", (Object)id);
                return ApplicationResponse.success((String)"School registration fetched successfully.", (Object)schoolDto);
            }
            log.warn("School not found with ID: {}", (Object)id);
            return ApplicationResponse.error((String)("School not found with ID: " + id));
        }
        catch (Exception e) {
            log.error("Error fetching school with ID: {}: {}", new Object[]{id, e.getMessage(), e});
            return ApplicationResponse.error((String)("Error fetching school: " + e.getMessage()));
        }
    }

    public ApplicationResponse<List<SchoolRegistrationDto>> getAllSchools(String token) {
        try {
            log.info("Fetching all schools.");
            List schools = this.schoolRegistrationRepository.findAll();
            if (schools.isEmpty()) {
                log.warn("No schools found in the system.");
                return ApplicationResponse.error((String)"No schools found.");
            }
            List schoolDtos = schools.stream().map(arg_0 -> ((SchoolRegistrationMapper)this.schoolRegistrationMapper).mapEntityToDto(arg_0)).collect(Collectors.toList());
            log.info("Fetched {} schools successfully.", (Object)schoolDtos.size());
            return ApplicationResponse.success((String)"All schools fetched successfully.", schoolDtos);
        }
        catch (DataAccessException dae) {
            log.error("Database error occurred while fetching schools: {}", (Object)dae.getMessage(), (Object)dae);
            return ApplicationResponse.error((String)("Database error occurred: " + dae.getMessage()));
        }
        catch (Exception e) {
            log.error("Unexpected error while fetching all schools: {}", (Object)e.getMessage(), (Object)e);
            return ApplicationResponse.error((String)("Unexpected error: " + e.getMessage()));
        }
    }

    public ApplicationResponse<SchoolRegistration> updateSchool(Long id, SchoolRegistrationDto request, String token) {
        try {
            log.info("Updating school with ID: {}", (Object)id);
            UserResponse loggerdetails = this.authenticationService.getTokenDetails(token);
            if (loggerdetails == null || loggerdetails.getId() == null) {
                throw new ValidationException("Invalid token or user details not found.");
            }
            User user = (User)this.userDao.findById(loggerdetails.getId()).orElseThrow(() -> new ValidationException("User not found with ID: " + loggerdetails.getId()));
            Optional schoolOpt = this.schoolRegistrationRepository.findById((Object)id);
            if (schoolOpt.isPresent()) {
                SchoolRegistration school = (SchoolRegistration)schoolOpt.get();
                this.schoolRegistrationMapper.updateEntityFromRequest(school, request);
                if (request.getApprovalStatus().booleanValue() && school.getSchoolRegistrationId() == null) {
                    boolean dbCreated = SchoolDatabaseCreator.createSchoolDatabase((String)school.getSchoolName());
                    if (!dbCreated) {
                        throw new RuntimeException("Failed to create database for the school.");
                    }
                    school.setSchoolRegistrationId(RandomCodeGenerator.generateSchoolRegistrationCode());
                    this.javaSendApi.sendRegistrationSuccessEmail(school.getEmailAddress(), school.getSchoolName(), school.getSchoolRegistrationId());
                }
                SchoolRegistration updatedSchool = (SchoolRegistration)this.schoolRegistrationRepository.save((Object)school);
                log.info("School updated successfully with ID: {}", (Object)id);
                return ApplicationResponse.success((String)"School registration updated successfully.", (Object)updatedSchool);
            }
            log.warn("School not found with ID: {}", (Object)id);
            return ApplicationResponse.error((String)("School not found with ID: " + id));
        }
        catch (Exception e) {
            log.error("Error updating school with ID: {}: {}", new Object[]{id, e.getMessage(), e});
            return ApplicationResponse.error((String)("Error updating school: " + e.getMessage()));
        }
    }

    public ApplicationResponse<Void> deleteSchool(Long id) {
        try {
            log.info("Deleting school with ID: {}", (Object)id);
            Optional schoolOpt = this.schoolRegistrationRepository.findById((Object)id);
            if (schoolOpt.isPresent()) {
                this.schoolRegistrationRepository.deleteById((Object)id);
                log.info("School deleted successfully with ID: {}", (Object)id);
                return ApplicationResponse.success((String)"School registration deleted successfully.", null);
            }
            log.warn("School not found with ID: {}", (Object)id);
            return ApplicationResponse.error((String)("School not found with ID: " + id));
        }
        catch (Exception e) {
            log.error("Error deleting school with ID: {}: {}", new Object[]{id, e.getMessage(), e});
            return ApplicationResponse.error((String)("Error deleting school: " + e.getMessage()));
        }
    }

    private User createNewUser(SchoolLoginRequest request) {
        return User.builder().firstname(request.getSchoolName()).contactperson(request.getContactPerson()).email(request.getEmail()).mobile(request.getMobile()).status(Boolean.valueOf(true)).password(this.encoder.encode((CharSequence)request.getPassword())).role(Role.CLIENT).build();
    }

    @Generated
    public SchoolRegistrationServiceImpl(SchoolRegistrationRepository schoolRegistrationRepository, PasswordEncoder encoder, UserDao userDao, JwtService jwtService, AuthenticationService authenticationService, SchoolRegistrationValidation registrationValidation, EmailSender javaSendApi, SchoolRegistrationMapper schoolRegistrationMapper) {
        this.schoolRegistrationRepository = schoolRegistrationRepository;
        this.encoder = encoder;
        this.userDao = userDao;
        this.jwtService = jwtService;
        this.authenticationService = authenticationService;
        this.registrationValidation = registrationValidation;
        this.javaSendApi = javaSendApi;
        this.schoolRegistrationMapper = schoolRegistrationMapper;
    }
}

