/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolTimeTable;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTable;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableDao;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableDto;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeTableServiceImpl
implements TimeTableService {
    @Autowired
    private TimeTableDao tableDao;

    public TimeTable saveTimeTable(TimeTableDto dto) {
        try {
            TimeTable table = new TimeTable();
            if (dto.getSection() != null) {
                table.setSection(dto.getSection());
            }
            if (dto.getSubject() != null) {
                table.setSubject(dto.getSubject());
            }
            if (dto.getStartTime() != null) {
                table.setStartTime(dto.getStartTime());
            }
            if (dto.getEndTime() != null) {
                table.setEndTime(dto.getEndTime());
            }
            if (dto.getDayOfWeek() != null) {
                table.setDayOfWeek(dto.getDayOfWeek());
            }
            if (dto.getTeacherId() != null) {
                table.setTeacherId(dto.getTeacherId());
            }
            return this.tableDao.saveTimeTable(table);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while save timetable" + e.getMessage());
        }
    }

    public List<TimeTable> getAllTimeTable() {
        try {
            List list = this.tableDao.getAllTimeTable();
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while get all timetable" + e.getMessage());
        }
    }

    public ApplicationResponse<Optional<TimeTable>> findByTimeTableId(Long id) {
        try {
            Optional optional = this.tableDao.findByTimeTableId(id);
            if (optional.isEmpty()) {
                return new ApplicationResponse("Error", "timetable not found", Optional.empty());
            }
            return new ApplicationResponse("Success", "Timetable found successfully", (Object)optional);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find by timetable id" + e.getMessage());
        }
    }

    public ApplicationResponse<TimeTable> deleteBytimeTableId(Long id) {
        try {
            this.tableDao.deleteBytimeTableId(id);
            return new ApplicationResponse("Success", "Timetable id delete successfully", null);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while delete by timetable id" + e.getMessage());
        }
    }

    public TimeTable updateByTimetableId(TimeTableDto dto, Long id) {
        try {
            Optional optional = this.tableDao.findByTimeTableId(id);
            TimeTable table = (TimeTable)optional.get();
            if (dto.getSection() != null) {
                table.setSection(dto.getSection());
            }
            if (dto.getSubject() != null) {
                table.setSubject(dto.getSubject());
            }
            if (dto.getStartTime() != null) {
                table.setStartTime(dto.getStartTime());
            }
            if (dto.getEndTime() != null) {
                table.setEndTime(dto.getEndTime());
            }
            if (dto.getDayOfWeek() != null) {
                table.setDayOfWeek(dto.getDayOfWeek());
            }
            if (dto.getTeacherId() != null) {
                table.setTeacherId(dto.getTeacherId());
            }
            return this.tableDao.updateByTimetableId(table);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while update by timetable id" + e.getMessage());
        }
    }
}

