/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolTimeTable;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTable;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableDto;
import com.rugaa.NambaSchool.schoolTimeTable.TimeTableService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/timetable"})
public class TimeTableController {
    @Autowired
    private TimeTableService timeTableService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<TimeTable> saveTimeTable(@RequestBody TimeTableDto dto) {
        try {
            TimeTable table = this.timeTableService.saveTimeTable(dto);
            return new ApplicationResponse("Success", "time table create successfully", (Object)table);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while save timetable", null);
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<List<TimeTable>> getAllTimeTable() {
        try {
            List list = this.timeTableService.getAllTimeTable();
            return new ApplicationResponse(null, null, (Object)list);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred whileget all timetable", null);
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<Optional<TimeTable>> findByTimeTableId(@RequestParam Long id) {
        try {
            return this.timeTableService.findByTimeTableId(id);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while find by timetable id", null);
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<TimeTable> deleteBytimeTableId(@RequestParam Long id) {
        try {
            return this.timeTableService.deleteBytimeTableId(id);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while delete by timetable id", null);
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<TimeTable> updateByTimetableId(@RequestBody TimeTableDto dto, @RequestParam Long id) {
        try {
            TimeTable table = this.timeTableService.updateByTimetableId(dto, id);
            return new ApplicationResponse(null, null, (Object)table);
        }
        catch (Exception e) {
            return new ApplicationResponse("Error", "An error occurred while update by timetable id", null);
        }
    }
}

