/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolEvent;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.schoolEvent.Event;
import com.rugaa.NambaSchool.schoolEvent.EventDao;
import com.rugaa.NambaSchool.schoolEvent.EventDto;
import com.rugaa.NambaSchool.schoolEvent.EventService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventServiceImpl
implements EventService {
    @Autowired
    private EventDao eventDao;

    public Event createEvent(EventDto dto) {
        try {
            Event event = new Event();
            if (dto.getTitle() != null) {
                event.setTitle(dto.getTitle());
            }
            if (dto.getEventName() != null) {
                event.setEventName(dto.getEventName());
            }
            if (dto.getDescription() != null) {
                event.setDescription(dto.getDescription());
            }
            if (dto.getStartDate() != null) {
                event.setStartDate(dto.getStartDate());
            }
            if (dto.getEndDate() != null) {
                event.setEndDate(dto.getEndDate());
            }
            if (dto.getCreatedTimeStamp() != null) {
                event.setCreatedTimeStamp(dto.getCreatedTimeStamp());
            }
            if (dto.getLastModifiedDate() != null) {
                event.setLastModifiedDate(dto.getLastModifiedDate());
            }
            return this.eventDao.createEvent(event);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while create event" + e.getMessage());
        }
    }

    public Event updateByEventId(EventDto dto, Long id) {
        try {
            Optional optional = this.eventDao.findByEventId(id);
            Event event = (Event)optional.get();
            if (dto.getTitle() != null) {
                event.setTitle(dto.getTitle());
            }
            if (dto.getEventName() != null) {
                event.setEventName(dto.getEventName());
            }
            if (dto.getDescription() != null) {
                event.setDescription(dto.getDescription());
            }
            if (dto.getStartDate() != null) {
                event.setStartDate(dto.getStartDate());
            }
            if (dto.getEndDate() != null) {
                event.setEndDate(dto.getEndDate());
            }
            if (dto.getCreatedTimeStamp() != null) {
                event.setCreatedTimeStamp(dto.getCreatedTimeStamp());
            }
            if (dto.getLastModifiedDate() != null) {
                event.setLastModifiedDate(dto.getLastModifiedDate());
            }
            return this.eventDao.updateByEventId(event);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while update by event id" + e.getMessage());
        }
    }

    public ApplicationResponse<Object> fetchAll() {
        try {
            List list = this.eventDao.fetchAll();
            if (list.isEmpty()) {
                return ApplicationResponse.error((String)"Event not found");
            }
            return ApplicationResponse.success(null, (Object)list);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find all event" + e.getMessage());
        }
    }

    public ApplicationResponse<Optional<Event>> findByEventId(Long id) {
        try {
            Optional optional = this.eventDao.findByEventId(id);
            if (optional.isEmpty()) {
                return ApplicationResponse.error((String)"event id is not found");
            }
            return ApplicationResponse.success(null, (Object)optional);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find by event id" + e.getMessage());
        }
    }

    public ApplicationResponse<String> deleteByEventId(Long id) {
        try {
            this.eventDao.deleteByEventId(id);
            return ApplicationResponse.success((String)"Success", (Object)"Event id is deleted successfully");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while delete by event id" + e.getMessage());
        }
    }
}

