/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.schoolEvent;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.schoolEvent.Event;
import com.rugaa.NambaSchool.schoolEvent.EventDto;
import com.rugaa.NambaSchool.schoolEvent.EventService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/event"})
public class EventController {
    @Autowired
    private EventService eventService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<Event> createEvent(@RequestBody EventDto dto) {
        try {
            Event response = this.eventService.createEvent(dto);
            return ApplicationResponse.success(null, (Object)response);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while create event" + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<Event> updateByEventId(@RequestBody EventDto dto, @RequestParam Long id) {
        try {
            Event response = this.eventService.updateByEventId(dto, id);
            return ApplicationResponse.success(null, (Object)response);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while update by event id" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<ApplicationResponse<Object>> fetchAll() {
        try {
            ApplicationResponse events = this.eventService.fetchAll();
            return ApplicationResponse.success(null, (Object)events);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find all event" + e.getMessage()));
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<ApplicationResponse<Optional<Event>>> findByEventId(@RequestParam Long id) {
        try {
            ApplicationResponse response = this.eventService.findByEventId(id);
            return ApplicationResponse.success(null, (Object)response);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by event id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<ApplicationResponse<String>> deleteByEventId(@RequestParam Long id) {
        try {
            ApplicationResponse response = this.eventService.deleteByEventId(id);
            return ApplicationResponse.success(null, (Object)response);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by event id" + e.getMessage()));
        }
    }
}

