/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.otp;

import com.rugaa.NambaSchool.exception.OTPDatabaseException;
import com.rugaa.NambaSchool.exception.OTPGenerationException;
import com.rugaa.NambaSchool.exception.OTPResendException;
import com.rugaa.NambaSchool.exception.OTPServiceException;
import com.rugaa.NambaSchool.exception.OTPVerificationException;
import com.rugaa.NambaSchool.otp.OTPData;
import com.rugaa.NambaSchool.otp.OTPDataRepository;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OTPService {
    private static final SecureRandom RANDOM = new SecureRandom();
    @Autowired
    private OTPDataRepository otpDataRepository;

    public boolean otpVerification(String otp, String mobile) {
        try {
            String otpCode = this.generateOTP();
            this.storeOTPInDatabase(mobile, otpCode);
            return this.verifyOTP(mobile, otp);
        }
        catch (Exception e) {
            throw new OTPServiceException("Error in OTP verification process: " + e.getMessage(), (Throwable)e);
        }
    }

    public String generateOTP() {
        try {
            int otpValue = RANDOM.nextInt(900000) + 100000;
            return String.valueOf(otpValue);
        }
        catch (Exception e) {
            throw new OTPGenerationException("Failed to generate OTP: " + e.getMessage(), (Throwable)e);
        }
    }

    public void storeOTPInDatabase(String mobile, String otpCode) {
        try {
            OTPData otpData = this.otpDataRepository.findByMobile(mobile);
            if (otpData != null) {
                otpData.setOtpcode(otpCode);
                otpData.setExpiresAt(Timestamp.from(Instant.now().plusSeconds(600L)));
                otpData.setVerified(Boolean.valueOf(false));
            } else {
                otpData = OTPData.builder().mobile(mobile).otpcode(otpCode).expiresAt(Timestamp.from(Instant.now().plusSeconds(600L))).verified(Boolean.valueOf(false)).build();
            }
            this.otpDataRepository.save((Object)otpData);
        }
        catch (Exception e) {
            throw new OTPDatabaseException("Error storing OTP in the database for mobile: " + mobile, (Throwable)e);
        }
    }

    public boolean verifyOTP(String mobile, String receivedOtp) {
        try {
            OTPData otpData = this.otpDataRepository.findByMobile(mobile);
            if (otpData != null) {
                String storedOtp = otpData.getOtpcode();
                Timestamp expirationTime = otpData.getExpiresAt();
                if (!otpData.getVerified().booleanValue() && storedOtp.equals(receivedOtp) && Instant.now().isBefore(expirationTime.toInstant())) {
                    otpData.setVerified(Boolean.valueOf(true));
                    this.otpDataRepository.save((Object)otpData);
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new OTPVerificationException("Error verifying OTP for mobile: " + mobile, (Throwable)e);
        }
    }

    public void resendOTP(String mobile) {
        try {
            String newOtpCode = this.generateOTP();
            this.storeOTPInDatabase(mobile, newOtpCode);
            System.out.println("New OTP: " + newOtpCode);
        }
        catch (Exception e) {
            throw new OTPResendException("Error resending OTP for mobile: " + mobile, (Throwable)e);
        }
    }

    public void deleteOTP(String mobile) {
        try {
            OTPData otpData = this.otpDataRepository.findByMobile(mobile);
            if (otpData != null) {
                this.otpDataRepository.delete((Object)otpData);
            }
        }
        catch (Exception e) {
            throw new OTPDatabaseException("Error deleting OTP for mobile: " + mobile, (Throwable)e);
        }
    }
}

