/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.notice;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.notice.NoticeBoard;
import com.rugaa.NambaSchool.notice.NoticeBoardDao;
import com.rugaa.NambaSchool.notice.NoticeBoardDto;
import com.rugaa.NambaSchool.notice.NoticeBoardService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoticeBoardServiceImpl
implements NoticeBoardService {
    @Autowired
    private NoticeBoardDao noticeBoardDao;

    public NoticeBoard createNoticeBoard(NoticeBoardDto dto) {
        try {
            NoticeBoard board = new NoticeBoard();
            if (dto.getTitle() != null) {
                board.setTitle(dto.getTitle());
            }
            if (dto.getDescription() != null) {
                board.setDescription(dto.getDescription());
            }
            if (dto.getContent() != null) {
                board.setContent(dto.getContent());
            }
            if (dto.getDate() != null) {
                board.setDate(dto.getDate());
            }
            if (dto.getImage() != null) {
                board.setImage(dto.getImage());
            }
            return this.noticeBoardDao.createNoticeBoard(board);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while cerate notice board" + e.getMessage());
        }
    }

    public NoticeBoard upadteByNoticeBoardId(NoticeBoardDto dto, Long id) {
        try {
            Optional optional = this.noticeBoardDao.findById(id);
            NoticeBoard board = (NoticeBoard)optional.get();
            if (dto.getTitle() != null) {
                board.setTitle(dto.getTitle());
            }
            if (dto.getDescription() != null) {
                board.setDescription(dto.getDescription());
            }
            if (dto.getContent() != null) {
                board.setContent(dto.getContent());
            }
            if (dto.getDate() != null) {
                board.setDate(dto.getDate());
            }
            if (dto.getImage() != null) {
                board.setImage(dto.getImage());
            }
            return this.noticeBoardDao.upadteByNoticeBoardId(board);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while update notice board" + e.getMessage());
        }
    }

    public ApplicationResponse<Object> fetchAll() {
        try {
            List list = this.noticeBoardDao.fetchAll();
            if (list.isEmpty()) {
                return ApplicationResponse.error((String)"Notice board not found");
            }
            return ApplicationResponse.success(null, (Object)list);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while fetch all notice board" + e.getMessage());
        }
    }

    public ApplicationResponse<Optional<NoticeBoard>> findByNoticeBoardId(Long id) {
        try {
            Optional optional = this.noticeBoardDao.findById(id);
            if (optional.isEmpty()) {
                return ApplicationResponse.error((String)"NoticeBoard not found");
            }
            return ApplicationResponse.success(null, (Object)optional);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find by notice board id" + e.getMessage());
        }
    }

    public ApplicationResponse<String> deleteByNoticeBoardId(Long id) {
        try {
            this.noticeBoardDao.deleteByNoticeBoardId(id);
            return ApplicationResponse.success((String)"Success", (Object)"notice board id is delete successfully");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while deleted by notice board id" + e.getMessage());
        }
    }
}

