/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.notice;

import com.rugaa.NambaSchool.appplicationresponse.ApplicationResponse;
import com.rugaa.NambaSchool.notice.NoticeBoard;
import com.rugaa.NambaSchool.notice.NoticeBoardDto;
import com.rugaa.NambaSchool.notice.NoticeBoardService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notice"})
public class NoticeBoardController {
    @Autowired
    private NoticeBoardService noticeBoardService;

    @PostMapping(value={"/save"})
    public ApplicationResponse<NoticeBoard> createNoticeBoard(@RequestBody NoticeBoardDto dto) {
        try {
            NoticeBoard board = this.noticeBoardService.createNoticeBoard(dto);
            return ApplicationResponse.success(null, (Object)board);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)"An error occurred while create noticeboard");
        }
    }

    @PostMapping(value={"/update"})
    public ApplicationResponse<NoticeBoard> upadteByNoticeBoardId(@RequestBody NoticeBoardDto dto, @RequestParam Long id) {
        try {
            NoticeBoard board = this.noticeBoardService.upadteByNoticeBoardId(dto, id);
            return ApplicationResponse.success(null, (Object)board);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)"An error occurred while update noticeboard");
        }
    }

    @GetMapping(value={"/findall"})
    public ApplicationResponse<ApplicationResponse<Object>> fetchAll() {
        try {
            ApplicationResponse boards = this.noticeBoardService.fetchAll();
            return ApplicationResponse.success(null, (Object)boards);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)"An error occurred while fetch all noticeboard");
        }
    }

    @GetMapping(value={"/findbyid"})
    public ApplicationResponse<ApplicationResponse<Optional<NoticeBoard>>> findByNoticeBoardId(@RequestParam Long id) {
        try {
            ApplicationResponse optional = this.noticeBoardService.findByNoticeBoardId(id);
            return ApplicationResponse.success(null, (Object)optional);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while find by noticeboard id" + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/delete"})
    public ApplicationResponse<ApplicationResponse<String>> deleteByNoticeBoardId(@RequestParam Long id) {
        try {
            ApplicationResponse response = this.noticeBoardService.deleteByNoticeBoardId(id);
            return ApplicationResponse.success(null, (Object)response);
        }
        catch (Exception e) {
            return ApplicationResponse.error((String)("An error occurred while delete by noticeboard id" + e.getMessage()));
        }
    }
}

