/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.dbCreator;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

public class SchoolDatabaseCreator {
    private static final Logger logger = Logger.getLogger(SchoolDatabaseCreator.class.getName());
    private static final String DB_URL = "jdbc:mysql://localhost:3306";
    private static final String DB_USERNAME = "root";
    private static final String DB_PASSWORD = "root";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSchoolDatabase(String schoolName) {
        Connection connection = null;
        Statement statement = null;
        boolean isSuccess = false;
        try {
            connection = DriverManager.getConnection(DB_URL, "root", "root");
            String newDatabaseName = "school_" + schoolName.replaceAll("\\s+", "_").toLowerCase();
            String sql = "CREATE DATABASE IF NOT EXISTS " + newDatabaseName;
            statement = connection.createStatement();
            statement.executeUpdate(sql);
            isSuccess = true;
            logger.info("Database created successfully for school: " + newDatabaseName);
        }
        catch (SQLException e) {
            logger.severe("Error creating database for school " + schoolName + ": " + e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                logger.severe("Error while closing resources: " + e.getMessage());
            }
        }
        return isSuccess;
    }
}

