/*
 * Decompiled with CFR 0.152.
 */
package com.rugaa.NambaSchool.transportRegister;

import com.rugaa.NambaSchool.exception.ValidationException;
import com.rugaa.NambaSchool.transportRegister.TransportDto;
import org.springframework.stereotype.Service;

@Service
public class TransportValidation {
    public void validateRequest(TransportDto transportDto) throws ValidationException {
        if (transportDto == null) {
            throw new ValidationException("TransportDto cannot be null");
        }
        if (transportDto.getVehicleNumber() == null || transportDto.getVehicleNumber().isEmpty()) {
            throw new ValidationException("Vehicle number is required");
        }
        if (transportDto.getVehicleType() == null || transportDto.getVehicleType().isEmpty()) {
            throw new ValidationException("Vehicle type is required");
        }
        if (transportDto.getDriverName() == null || transportDto.getDriverName().isEmpty()) {
            throw new ValidationException("Driver name is required");
        }
        if (transportDto.getDriverAddress() == null || transportDto.getDriverAddress().isEmpty()) {
            throw new ValidationException("Driver address is required");
        }
        if (transportDto.getDriverMobile() == null || !this.isValidMobile(transportDto.getDriverMobile())) {
            throw new ValidationException("Valid 10-digit driver mobile number is required");
        }
        if (transportDto.getEmergencyContact() == null || !this.isValidMobile(transportDto.getEmergencyContact())) {
            throw new ValidationException("Valid 10-digit emergency contact number is required");
        }
        if (transportDto.getBusRoute() == null || transportDto.getBusRoute().isEmpty()) {
            throw new ValidationException("Bus route is required");
        }
        if (transportDto.getRouteType() == null || transportDto.getRouteType().isEmpty()) {
            throw new ValidationException("Route type is required");
        }
        if (transportDto.getGpsTracking() == null || transportDto.getGpsTracking().isEmpty()) {
            throw new ValidationException("GPS tracking status is required");
        }
        if (transportDto.getStudent() == null || transportDto.getStudent().isEmpty()) {
            throw new ValidationException("Student information is required");
        }
        if (transportDto.getStaff() == null || transportDto.getStaff().isEmpty()) {
            throw new ValidationException("Staff information is required");
        }
        if (transportDto.getPickupLocation() == null || transportDto.getPickupLocation().isEmpty()) {
            throw new ValidationException("Pickup location is required");
        }
        if (transportDto.getDropLocation() == null || transportDto.getDropLocation().isEmpty()) {
            throw new ValidationException("Drop location is required");
        }
    }

    private boolean isValidMobile(Long driverMobile) {
        String mobileRegex = "^[0-9]{10}$";
        return String.valueOf(driverMobile).matches(mobileRegex);
    }
}

